/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.instrumentation.DataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentationContext;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.observation.DataFetcherObservationContext;
import org.springframework.graphql.observation.DataFetcherObservationConvention;
import org.springframework.graphql.observation.DataLoaderObservationContext;
import org.springframework.graphql.observation.DataLoaderObservationConvention;
import org.springframework.graphql.observation.DefaultDataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultDataLoaderObservationConvention;
import org.springframework.graphql.observation.DefaultExecutionRequestObservationConvention;
import org.springframework.graphql.observation.ExecutionRequestObservationContext;
import org.springframework.graphql.observation.ExecutionRequestObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class GraphQlObservationInstrumentation
extends SimplePerformantInstrumentation {
    private static final ExecutionRequestObservationConvention DEFAULT_REQUEST_CONVENTION = new DefaultExecutionRequestObservationConvention();
    private static final DataFetcherObservationConvention DEFAULT_DATA_FETCHER_CONVENTION = new DefaultDataFetcherObservationConvention();
    private static final DefaultDataLoaderObservationConvention DEFAULT_DATA_LOADER_CONVENTION = new DefaultDataLoaderObservationConvention();
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ExecutionRequestObservationConvention requestObservationConvention;
    @Nullable
    private final DataFetcherObservationConvention dataFetcherObservationConvention;
    @Nullable
    private final DataLoaderObservationConvention dataLoaderObservationConvention;

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry) {
        this(observationRegistry, null, null, null);
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry, @Nullable ExecutionRequestObservationConvention requestObservationConvention, @Nullable DataFetcherObservationConvention dateFetcherObservationConvention) {
        this(observationRegistry, requestObservationConvention, dateFetcherObservationConvention, null);
    }

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry, @Nullable ExecutionRequestObservationConvention requestObservationConvention, @Nullable DataFetcherObservationConvention dateFetcherObservationConvention, @Nullable DataLoaderObservationConvention dataLoaderObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = requestObservationConvention;
        this.dataFetcherObservationConvention = dateFetcherObservationConvention;
        this.dataLoaderObservationConvention = dataLoaderObservationConvention;
    }

    @NonNull
    public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        return executionInput.transform(builder -> {
            DataLoaderRegistry dataLoaderRegistry = DataLoaderRegistry.newRegistry().registerAll(executionInput.getDataLoaderRegistry()).instrumentation((DataLoaderInstrumentation)new ObservationDataLoaderInstrumentation()).build();
            builder.dataLoaderRegistry(dataLoaderRegistry);
        });
    }

    public CompletableFuture<InstrumentationState> createStateAsync(InstrumentationCreateStateParameters parameters) {
        ExecutionRequestObservationContext requestObservationContext = new ExecutionRequestObservationContext(parameters.getExecutionInput());
        return CompletableFuture.completedFuture(new RequestObservationInstrumentationState(requestObservationContext));
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (state instanceof RequestObservationInstrumentationState) {
            RequestObservationInstrumentationState observationState = (RequestObservationInstrumentationState)state;
            final ExecutionRequestObservationContext observationContext = observationState.requestObservationContext;
            final Observation requestObservation = GraphQlObservationDocumentation.EXECUTION_REQUEST.observation(this.requestObservationConvention, DEFAULT_REQUEST_CONVENTION, () -> observationContext, this.observationRegistry);
            GraphQlObservationInstrumentation.setCurrentObservation(requestObservation, parameters.getGraphQLContext());
            requestObservation.start();
            return new SimpleInstrumentationContext<ExecutionResult>(this){
                final /* synthetic */ GraphQlObservationInstrumentation this$0;
                {
                    this.this$0 = this$0;
                }

                public void onCompleted(ExecutionResult result, @Nullable Throwable exc) {
                    observationContext.setExecutionResult(result);
                    result.getErrors().forEach(graphQLError -> {
                        Observation.Event event = Observation.Event.of((String)graphQLError.getErrorType().toString(), (String)graphQLError.getMessage());
                        requestObservation.event(event);
                    });
                    if (exc != null) {
                        requestObservation.error(exc);
                    }
                    requestObservation.stop();
                }
            };
        }
        return super.beginExecution(parameters, state);
    }

    private static void setCurrentObservation(Observation currentObservation, GraphQLContext graphQlContext) {
        Observation parentObservation = (Observation)graphQlContext.get((Object)"micrometer.observation");
        currentObservation.parentObservation(parentObservation);
        graphQlContext.put((Object)"micrometer.observation", (Object)currentObservation);
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters, InstrumentationState state) {
        if (state instanceof RequestObservationInstrumentationState) {
            RequestObservationInstrumentationState observationState = (RequestObservationInstrumentationState)state;
            observationState.requestObservationContext.setExecutionContext(parameters.getExecutionContext());
        }
        return super.beginExecuteOperation(parameters, state);
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (!parameters.isTrivialDataFetcher() && state instanceof RequestObservationInstrumentationState) {
            SelfDescribingDataFetcher selfDescribingDataFetcher;
            if (dataFetcher instanceof SelfDescribingDataFetcher && (selfDescribingDataFetcher = (SelfDescribingDataFetcher)dataFetcher).usesDataLoader()) {
                return dataFetcher;
            }
            return environment -> {
                DataFetcherObservationContext observationContext = new DataFetcherObservationContext(environment);
                Observation dataFetcherObservation = GraphQlObservationDocumentation.DATA_FETCHER.observation(this.dataFetcherObservationConvention, DEFAULT_DATA_FETCHER_CONVENTION, () -> observationContext, this.observationRegistry);
                dataFetcherObservation.parentObservation(GraphQlObservationInstrumentation.getCurrentObservation(environment));
                dataFetcherObservation.start();
                DataFetchingEnvironment dataFetchingEnvironment = GraphQlObservationInstrumentation.wrapDataFetchingEnvironment(environment, dataFetcherObservation);
                try {
                    Object value = dataFetcher.get(dataFetchingEnvironment);
                    if (value instanceof CompletionStage) {
                        CompletionStage completion = (CompletionStage)value;
                        return completion.handle((result, error) -> {
                            observationContext.setValue(result);
                            if (error != null) {
                                if (error instanceof CompletionException) {
                                    CompletionException completionException = (CompletionException)error;
                                    dataFetcherObservation.error(error.getCause());
                                    dataFetcherObservation.stop();
                                    throw completionException;
                                }
                                dataFetcherObservation.error(error);
                                dataFetcherObservation.stop();
                                throw new CompletionException((Throwable)error);
                            }
                            dataFetcherObservation.stop();
                            return result;
                        });
                    }
                    observationContext.setValue(value);
                    dataFetcherObservation.stop();
                    return value;
                }
                catch (Throwable throwable) {
                    dataFetcherObservation.error(throwable);
                    dataFetcherObservation.stop();
                    throw throwable;
                }
            };
        }
        return dataFetcher;
    }

    @Nullable
    private static Observation getCurrentObservation(DataFetchingEnvironment environment) {
        Observation currentObservation = null;
        Object object = environment.getLocalContext();
        if (object instanceof GraphQLContext) {
            GraphQLContext localContext = (GraphQLContext)object;
            currentObservation = (Observation)localContext.get((Object)"micrometer.observation");
        }
        if (currentObservation == null) {
            currentObservation = (Observation)environment.getGraphQlContext().get((Object)"micrometer.observation");
        }
        return currentObservation;
    }

    private static DataFetchingEnvironment wrapDataFetchingEnvironment(DataFetchingEnvironment environment, Observation dataFetcherObservation) {
        if (environment.getLocalContext() == null || environment.getLocalContext() instanceof GraphQLContext) {
            GraphQLContext.Builder localContextBuilder = GraphQLContext.newContext();
            Object object = environment.getLocalContext();
            if (object instanceof GraphQLContext) {
                GraphQLContext localContext = (GraphQLContext)object;
                localContextBuilder.of(localContext);
            }
            localContextBuilder.of((Object)"micrometer.observation", (Object)dataFetcherObservation);
            return DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)environment).localContext((Object)localContextBuilder.build()).build();
        }
        return environment;
    }

    static class RequestObservationInstrumentationState
    implements InstrumentationState {
        final ExecutionRequestObservationContext requestObservationContext;

        RequestObservationInstrumentationState(ExecutionRequestObservationContext requestObservationContext) {
            this.requestObservationContext = requestObservationContext;
        }
    }

    class ObservationDataLoaderInstrumentation
    implements DataLoaderInstrumentation {
        ObservationDataLoaderInstrumentation() {
        }

        public DataLoaderInstrumentationContext<List<?>> beginBatchLoader(DataLoader<?, ?> dataLoader, List<?> keys, BatchLoaderEnvironment environment) {
            final Observation observation = GraphQlObservationDocumentation.DATA_LOADER.observation(GraphQlObservationInstrumentation.this.dataLoaderObservationConvention, DEFAULT_DATA_LOADER_CONVENTION, () -> new DataLoaderObservationContext(dataLoader, keys, environment), GraphQlObservationInstrumentation.this.observationRegistry);
            Object object = environment.getContext();
            if (object instanceof GraphQLContext) {
                GraphQLContext graphQLContext = (GraphQLContext)object;
                Observation parentObservation = (Observation)graphQLContext.get((Object)"micrometer.observation");
                observation.parentObservation(parentObservation);
            }
            return new DataLoaderInstrumentationContext<List<?>>(){
                final /* synthetic */ ObservationDataLoaderInstrumentation this$1;
                {
                    this.this$1 = this$1;
                }

                public void onDispatched() {
                    observation.start();
                }

                public void onCompleted(List<?> result, @Nullable Throwable t) {
                    DataLoaderObservationContext context = (DataLoaderObservationContext)observation.getContext();
                    context.setResult(result);
                    if (t != null) {
                        observation.error(t);
                    }
                    observation.stop();
                }
            };
        }
    }
}

