/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.security.Principal;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import reactor.core.publisher.Mono;

public class PrincipalMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return Principal.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        return PrincipalMethodArgumentResolver.resolveAuthentication(parameter);
    }

    static Object resolveAuthentication(MethodParameter parameter) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            return auth;
        }
        Mono authMono = ReactiveSecurityContextHolder.getContext().mapNotNull(SecurityContext::getAuthentication);
        if (PrincipalMethodArgumentResolver.isRequired(parameter)) {
            authMono = authMono.switchIfEmpty(Mono.error((Throwable)new AuthenticationCredentialsNotFoundException("No Authentication")));
        }
        return authMono;
    }

    private static boolean isRequired(MethodParameter parameter) {
        return !parameter.isOptional() && !Mono.class.isAssignableFrom(parameter.getParameterType());
    }
}

