/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.support.SerializableGraphQlRequest;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.IdGenerator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

public abstract class AbstractGraphQlHttpHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final IdGenerator idGenerator = new AlternativeJdkIdGenerator();
    private final WebGraphQlHandler graphQlHandler;
    @Nullable
    private final HttpMessageConverter<Object> messageConverter;

    protected AbstractGraphQlHttpHandler(WebGraphQlHandler graphQlHandler, @Nullable HttpMessageConverter<?> messageConverter) {
        Assert.notNull((Object)graphQlHandler, (String)"WebGraphQlHandler is required");
        this.graphQlHandler = graphQlHandler;
        this.messageConverter = messageConverter;
    }

    @Nullable
    protected ServerResponse.HeadersBuilder.WriteFunction getWriteFunction(Map<String, Object> resultMap, MediaType contentType) {
        return this.messageConverter != null ? new MessageConverterWriteFunction(resultMap, contentType, this.messageConverter) : null;
    }

    public ServerResponse handleRequest(ServerRequest request) throws ServletException {
        WebGraphQlRequest graphQlRequest = new WebGraphQlRequest(request.uri(), request.headers().asHttpHeaders(), AbstractGraphQlHttpHandler.initCookies(request), (InetSocketAddress)request.remoteAddress().orElse(null), (Map<String, Object>)request.attributes(), this.readBody(request), this.idGenerator.generateId().toString(), LocaleContextHolder.getLocale());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing: " + String.valueOf(graphQlRequest)));
        }
        Mono responseMono = this.graphQlHandler.handleRequest(graphQlRequest).doOnNext(response -> {
            if (this.logger.isDebugEnabled()) {
                List<ResponseError> errors = response.getErrors();
                this.logger.debug((Object)("Execution result " + (String)(!CollectionUtils.isEmpty(errors) ? "has errors: " + String.valueOf(errors) : "is ready") + "."));
            }
        });
        return this.prepareResponse(request, (Mono<WebGraphQlResponse>)responseMono);
    }

    private static MultiValueMap<String, HttpCookie> initCookies(ServerRequest serverRequest) {
        MultiValueMap source = serverRequest.cookies();
        LinkedMultiValueMap target = new LinkedMultiValueMap(source.size());
        source.values().forEach(arg_0 -> AbstractGraphQlHttpHandler.lambda$initCookies$2((MultiValueMap)target, arg_0));
        return target;
    }

    private GraphQlRequest readBody(ServerRequest request) throws ServletException {
        try {
            if (this.messageConverter != null) {
                MediaType contentType;
                ServerRequest.Headers headers = request.headers();
                try {
                    contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                }
                catch (InvalidMediaTypeException ex) {
                    throw new UnsupportedMediaTypeStatusException("Could not parse Content-Type [" + headers.firstHeader("Content-Type") + "]: " + ex.getMessage());
                }
                if (this.messageConverter.canRead(SerializableGraphQlRequest.class, contentType)) {
                    ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request.servletRequest());
                    return (GraphQlRequest)this.messageConverter.read(SerializableGraphQlRequest.class, (HttpInputMessage)httpRequest);
                }
                throw new HttpMediaTypeNotSupportedException(contentType, this.messageConverter.getSupportedMediaTypes(), request.method());
            }
            try {
                return (GraphQlRequest)request.body(SerializableGraphQlRequest.class);
            }
            catch (HttpMediaTypeNotSupportedException ex) {
                return AbstractGraphQlHttpHandler.applyApplicationGraphQlFallback(request, ex);
            }
        }
        catch (IOException ex) {
            throw new ServerWebInputException("I/O error while reading request body", null, (Throwable)ex);
        }
    }

    private static SerializableGraphQlRequest applyApplicationGraphQlFallback(ServerRequest request, HttpMediaTypeNotSupportedException ex) throws HttpMediaTypeNotSupportedException {
        String contentTypeHeader = request.headers().firstHeader("Content-Type");
        if (StringUtils.hasText((String)contentTypeHeader)) {
            MediaType contentType = MediaType.parseMediaType((String)contentTypeHeader);
            MediaType applicationGraphQl = MediaType.parseMediaType((String)"application/graphql");
            if (applicationGraphQl.includes(contentType)) {
                try {
                    request = ServerRequest.from((ServerRequest)request).headers(headers -> headers.setContentType(MediaType.APPLICATION_JSON)).body((byte[])request.body(byte[].class)).build();
                    return (SerializableGraphQlRequest)request.body(SerializableGraphQlRequest.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        throw ex;
    }

    protected abstract ServerResponse prepareResponse(ServerRequest var1, Mono<WebGraphQlResponse> var2) throws ServletException;

    private static /* synthetic */ void lambda$initCookies$2(MultiValueMap target, List cookieList) {
        cookieList.forEach(cookie -> {
            HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
            target.add((Object)cookie.getName(), (Object)httpCookie);
        });
    }

    private record MessageConverterWriteFunction(Map<String, Object> resultMap, MediaType contentType, HttpMessageConverter<Object> converter) implements ServerResponse.HeadersBuilder.WriteFunction
    {
        public ModelAndView write(HttpServletRequest request, HttpServletResponse response) throws Exception {
            ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
            this.converter.write(this.resultMap, this.contentType, (HttpOutputMessage)httpResponse);
            return null;
        }
    }
}

