/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.language.FieldDefinition;
import graphql.language.ImplementingTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.graphql.execution.TypeDefinitionConfigurer;

public class ConnectionTypeDefinitionConfigurer
implements TypeDefinitionConfigurer {
    private static final TypeName STRING_TYPE = new TypeName("String");
    private static final TypeName BOOLEAN_TYPE = new TypeName("Boolean");
    private static final TypeName PAGE_INFO_TYPE = new TypeName("PageInfo");

    @Override
    public void configure(TypeDefinitionRegistry registry) {
        Set<String> typeNames = ConnectionTypeDefinitionConfigurer.findConnectionTypeNames(registry);
        if (!typeNames.isEmpty()) {
            registry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name(PAGE_INFO_TYPE.getName()).fieldDefinition(this.initFieldDefinition("hasPreviousPage", (Type<?>)new NonNullType((Type)BOOLEAN_TYPE))).fieldDefinition(this.initFieldDefinition("hasNextPage", (Type<?>)new NonNullType((Type)BOOLEAN_TYPE))).fieldDefinition(this.initFieldDefinition("startCursor", (Type<?>)STRING_TYPE)).fieldDefinition(this.initFieldDefinition("endCursor", (Type<?>)STRING_TYPE)).build());
            typeNames.forEach(typeName -> {
                String connectionTypeName = typeName + "Connection";
                String edgeTypeName = typeName + "Edge";
                registry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name(connectionTypeName).fieldDefinition(this.initFieldDefinition("edges", (Type<?>)new NonNullType((Type)new ListType((Type)new TypeName(edgeTypeName))))).fieldDefinition(this.initFieldDefinition("pageInfo", (Type<?>)new NonNullType((Type)PAGE_INFO_TYPE))).build());
                registry.add((SDLDefinition)ObjectTypeDefinition.newObjectTypeDefinition().name(edgeTypeName).fieldDefinition(this.initFieldDefinition("cursor", (Type<?>)new NonNullType((Type)STRING_TYPE))).fieldDefinition(this.initFieldDefinition("node", (Type<?>)new NonNullType((Type)new TypeName(typeName)))).build());
            });
        }
    }

    private static Set<String> findConnectionTypeNames(TypeDefinitionRegistry registry) {
        return Stream.concat(registry.types().values().stream(), registry.objectTypeExtensions().values().stream().flatMap(Collection::stream)).filter(definition -> definition instanceof ImplementingTypeDefinition).flatMap(definition -> {
            ImplementingTypeDefinition typeDefinition = (ImplementingTypeDefinition)definition;
            return typeDefinition.getFieldDefinitions().stream().map(fieldDefinition -> {
                Type type = fieldDefinition.getType();
                return type instanceof NonNullType ? ((NonNullType)type).getType() : type;
            }).filter(type -> type instanceof TypeName).map(type -> ((TypeName)type).getName()).filter(name -> name.endsWith("Connection")).filter(name -> registry.getType(name).isEmpty()).map(name -> name.substring(0, name.length() - "Connection".length()));
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private FieldDefinition initFieldDefinition(String name, Type<?> returnType) {
        return FieldDefinition.newFieldDefinition().name(name).type(returnType).build();
    }
}

