/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.ClientGraphQlRequest;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.client.ResponseMapGraphQlResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpGraphQlTransport
implements GraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final MediaType APPLICATION_GRAPHQL_RESPONSE = new MediaType("application", "graphql-response+json");
    private final WebClient webClient;
    private final MediaType contentType;

    HttpGraphQlTransport(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"WebClient is required");
        this.webClient = webClient;
        this.contentType = HttpGraphQlTransport.initContentType(webClient);
    }

    private static MediaType initContentType(WebClient webClient) {
        HttpHeaders headers = new HttpHeaders();
        webClient.mutate().defaultHeaders(arg_0 -> ((HttpHeaders)headers).putAll(arg_0));
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType : MediaType.APPLICATION_JSON;
    }

    @Override
    public Mono<GraphQlResponse> execute(GraphQlRequest request) {
        return ((WebClient.RequestBodySpec)this.webClient.post().contentType(this.contentType).accept(new MediaType[]{MediaType.APPLICATION_JSON, APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_GRAPHQL})).bodyValue(request.toMap()).attributes(attributes -> {
            if (request instanceof ClientGraphQlRequest) {
                ClientGraphQlRequest clientRequest = (ClientGraphQlRequest)request;
                attributes.putAll(clientRequest.getAttributes());
            }
        }).retrieve().bodyToMono(MAP_TYPE).map(ResponseMapGraphQlResponse::new);
    }

    @Override
    public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
        throw new UnsupportedOperationException("Subscriptions not supported over HTTP");
    }
}

