/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import graphql.ExecutionResult;
import java.util.function.Consumer;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import org.springframework.http.HttpHeaders;

public class WebGraphQlResponse
extends DefaultExecutionGraphQlResponse {
    private final HttpHeaders responseHeaders;

    public WebGraphQlResponse(ExecutionGraphQlResponse response) {
        super(response);
        this.responseHeaders = new HttpHeaders();
    }

    private WebGraphQlResponse(WebGraphQlResponse original, ExecutionResult executionResult) {
        super(original.getExecutionInput(), executionResult);
        this.responseHeaders = original.getResponseHeaders();
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public WebGraphQlResponse transform(Consumer<Builder> consumer) {
        Builder builder = new Builder(this);
        consumer.accept(builder);
        return (WebGraphQlResponse)builder.build();
    }

    public static final class Builder
    extends DefaultExecutionGraphQlResponse.Builder<Builder, WebGraphQlResponse> {
        private Builder(WebGraphQlResponse original) {
            super(original);
        }

        @Override
        protected WebGraphQlResponse build(WebGraphQlResponse original, ExecutionResult newResult) {
            return new WebGraphQlResponse(original, newResult);
        }
    }
}

