/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.InvocableHandlerMethodSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DataFetcherHandlerMethod
extends InvocableHandlerMethodSupport {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final HandlerMethodArgumentResolverComposite resolvers;
    private final Consumer<Object[]> validationHelper;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final boolean subscription;

    public DataFetcherHandlerMethod(HandlerMethod handlerMethod, HandlerMethodArgumentResolverComposite resolvers, @Nullable Consumer<Object[]> validationHelper, @Nullable Executor executor, boolean subscription) {
        super(handlerMethod, executor);
        Assert.isTrue((!resolvers.getResolvers().isEmpty() ? 1 : 0) != 0, (String)"No argument resolvers");
        this.resolvers = resolvers;
        this.validationHelper = validationHelper != null ? validationHelper : args -> {};
        this.subscription = subscription;
    }

    public HandlerMethodArgumentResolverComposite getResolvers() {
        return this.resolvers;
    }

    @Nullable
    public Object invoke(DataFetchingEnvironment environment) {
        Object[] args;
        try {
            args = this.getMethodArgumentValues(environment, new Object[0]);
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
        if (Arrays.stream(args).noneMatch(arg -> arg instanceof Mono)) {
            return this.validateAndInvoke(args, environment);
        }
        return this.subscription ? this.toArgsMono(args).flatMapMany(argValues -> {
            Object result = this.validateAndInvoke((Object[])argValues, environment);
            Assert.state((boolean)(result instanceof Publisher), (String)"Expected a Publisher from a Subscription response");
            return Flux.from((Publisher)((Publisher)result));
        }) : this.toArgsMono(args).flatMap(argValues -> {
            Object result = this.validateAndInvoke((Object[])argValues, environment);
            if (result instanceof Mono) {
                return (Mono)result;
            }
            if (result instanceof Flux) {
                return Flux.from((Publisher)((Flux)result)).collectList();
            }
            return Mono.justOrEmpty((Object)result);
        });
    }

    private Object[] getMethodArgumentValues(DataFetchingEnvironment environment, Object ... providedArgs) throws Exception {
        Object[] parameters = this.getMethodParameters();
        if (ObjectUtils.isEmpty((Object[])parameters)) {
            return EMPTY_ARGS;
        }
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            args[i] = DataFetcherHandlerMethod.findProvidedArgument((MethodParameter)parameter, providedArgs);
            if (args[i] != null) continue;
            if (!this.resolvers.supportsParameter((MethodParameter)parameter)) {
                throw new IllegalStateException(DataFetcherHandlerMethod.formatArgumentError((MethodParameter)parameter, "No suitable resolver"));
            }
            try {
                args[i] = this.resolvers.resolveArgument((MethodParameter)parameter, environment);
                continue;
            }
            catch (Exception ex) {
                String exMsg;
                if (logger.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(parameter.getExecutable().toGenericString())) {
                    logger.debug((Object)DataFetcherHandlerMethod.formatArgumentError((MethodParameter)parameter, exMsg));
                }
                throw ex;
            }
        }
        return args;
    }

    @Nullable
    private Object validateAndInvoke(Object[] args, DataFetchingEnvironment environment) {
        this.validationHelper.accept(args);
        return this.doInvoke(environment.getGraphQlContext(), args);
    }
}

