/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.http.MediaType;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

public class GraphQlHttpHandler {
    private static final Log logger = LogFactory.getLog(GraphQlHttpHandler.class);
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_PARAMETERIZED_TYPE_REF = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_GRAPHQL, MediaType.APPLICATION_JSON);
    private final IdGenerator idGenerator = new AlternativeJdkIdGenerator();
    private final WebGraphQlHandler graphQlHandler;

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        Assert.notNull((Object)graphQlHandler, (String)"WebGraphQlHandler is required");
        this.graphQlHandler = graphQlHandler;
    }

    public ServerResponse handleRequest(ServerRequest serverRequest) throws ServletException {
        WebGraphQlRequest graphQlRequest = new WebGraphQlRequest(serverRequest.uri(), serverRequest.headers().asHttpHeaders(), GraphQlHttpHandler.readBody(serverRequest), this.idGenerator.generateId().toString(), LocaleContextHolder.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing: " + graphQlRequest));
        }
        Mono responseMono = this.graphQlHandler.handleRequest(graphQlRequest).map(response -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Execution complete");
            }
            ServerResponse.BodyBuilder builder = ServerResponse.ok();
            builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
            builder.contentType(GraphQlHttpHandler.selectResponseMediaType(serverRequest));
            return builder.body(response.toMap());
        });
        return ServerResponse.async((Object)responseMono);
    }

    private static Map<String, Object> readBody(ServerRequest request) throws ServletException {
        try {
            return (Map)request.body(MAP_PARAMETERIZED_TYPE_REF);
        }
        catch (IOException ex) {
            throw new ServerWebInputException("I/O error while reading request body", null, (Throwable)ex);
        }
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        for (MediaType accepted : serverRequest.headers().accept()) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_GRAPHQL;
    }
}

