/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dataloader.BatchLoaderEnvironment;
import org.springframework.graphql.execution.ThreadLocalAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ReactorContextManager {
    private static final String CONTEXT_VIEW_KEY = ReactorContextManager.class.getName() + ".CONTEXT_VIEW";
    private static final String THREAD_ID = ReactorContextManager.class.getName() + ".THREAD_ID";
    private static final String THREAD_LOCAL_VALUES_KEY = ReactorContextManager.class.getName() + ".THREAD_VALUES_ACCESSOR";
    private static final String THREAD_LOCAL_ACCESSOR_KEY = ReactorContextManager.class.getName() + ".THREAD_LOCAL_ACCESSOR";

    static void setReactorContext(ContextView contextView, ExecutionInput input) {
        input.getGraphQLContext().put((Object)CONTEXT_VIEW_KEY, (Object)contextView);
    }

    static ContextView getReactorContext(DataFetchingEnvironment environment) {
        GraphQLContext graphQlContext = environment.getGraphQlContext();
        return (ContextView)graphQlContext.getOrDefault((Object)CONTEXT_VIEW_KEY, (Object)Context.empty());
    }

    static ContextView getReactorContext(BatchLoaderEnvironment environment) {
        Object context = environment.getContext();
        Assert.isTrue((boolean)(context instanceof GraphQLContext), (String)"Expected GraphQLContext in BatchLoaderEnvironment");
        return (ContextView)((GraphQLContext)context).getOrDefault((Object)CONTEXT_VIEW_KEY, (Object)Context.empty());
    }

    public static Context extractThreadLocalValues(ThreadLocalAccessor accessor, Context context) {
        LinkedHashMap<String, Object> valuesMap = new LinkedHashMap<String, Object>();
        accessor.extractValues(valuesMap);
        if (valuesMap.isEmpty()) {
            return context;
        }
        return context.putAll((ContextView)Context.of((Object)THREAD_LOCAL_VALUES_KEY, valuesMap, (Object)THREAD_LOCAL_ACCESSOR_KEY, (Object)accessor, (Object)THREAD_ID, (Object)Thread.currentThread().getId()));
    }

    static void restoreThreadLocalValues(ContextView contextView) {
        ThreadLocalAccessor accessor = ReactorContextManager.getThreadLocalAccessor(contextView);
        if (accessor != null) {
            accessor.restoreValues((Map)contextView.get((Object)THREAD_LOCAL_VALUES_KEY));
        }
    }

    static void resetThreadLocalValues(ContextView contextView) {
        ThreadLocalAccessor accessor = ReactorContextManager.getThreadLocalAccessor(contextView);
        if (accessor != null) {
            accessor.resetValues((Map)contextView.get((Object)THREAD_LOCAL_VALUES_KEY));
        }
    }

    @Nullable
    private static ThreadLocalAccessor getThreadLocalAccessor(ContextView view) {
        Long id = (Long)view.getOrDefault((Object)THREAD_ID, null);
        return id != null && id.longValue() != Thread.currentThread().getId() ? (ThreadLocalAccessor)view.get((Object)THREAD_LOCAL_ACCESSOR_KEY) : null;
    }
}

