/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.ReactorContextManager;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public abstract class DataFetcherExceptionResolverAdapter
implements DataFetcherExceptionResolver {
    private boolean threadLocalContextAware;

    protected DataFetcherExceptionResolverAdapter() {
    }

    public void setThreadLocalContextAware(boolean threadLocalContextAware) {
        this.threadLocalContextAware = threadLocalContextAware;
    }

    public boolean isThreadLocalContextAware() {
        return this.threadLocalContextAware;
    }

    @Override
    public final Mono<List<GraphQLError>> resolveException(Throwable ex, DataFetchingEnvironment env) {
        return Mono.defer(() -> Mono.justOrEmpty(this.resolveInternal(ex, env)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<GraphQLError> resolveInternal(Throwable ex, DataFetchingEnvironment env) {
        if (!this.threadLocalContextAware) {
            return this.resolveToMultipleErrors(ex, env);
        }
        ContextView contextView = ReactorContextManager.getReactorContext(env);
        try {
            ReactorContextManager.restoreThreadLocalValues(contextView);
            List<GraphQLError> list = this.resolveToMultipleErrors(ex, env);
            return list;
        }
        finally {
            ReactorContextManager.resetThreadLocalValues(contextView);
        }
    }

    @Nullable
    protected List<GraphQLError> resolveToMultipleErrors(Throwable ex, DataFetchingEnvironment env) {
        GraphQLError error = this.resolveToSingleError(ex, env);
        return error != null ? Collections.singletonList(error) : null;
    }

    @Nullable
    protected GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment env) {
        return null;
    }

    public static DataFetcherExceptionResolverAdapter from(final BiFunction<Throwable, DataFetchingEnvironment, GraphQLError> resolver) {
        return new DataFetcherExceptionResolverAdapter(){

            @Override
            protected GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment env) {
                return (GraphQLError)resolver.apply(ex, env);
            }
        };
    }
}

