/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import org.reactivestreams.Publisher;
import org.springframework.graphql.execution.ReactorContextManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

final class ContextDataFetcherDecorator
implements DataFetcher<Object> {
    private final DataFetcher<?> delegate;
    private final boolean subscription;
    static GraphQLTypeVisitor TYPE_VISITOR = new GraphQLTypeVisitorStub(){

        public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition fieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
            GraphQLFieldsContainer parent;
            GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
            DataFetcher dataFetcher = codeRegistry.getDataFetcher(parent = (GraphQLFieldsContainer)context.getParentNode(), fieldDefinition);
            if (dataFetcher.getClass().getPackage().getName().startsWith("graphql.")) {
                return TraversalControl.CONTINUE;
            }
            boolean handlesSubscription = parent.getName().equals("Subscription");
            dataFetcher = new ContextDataFetcherDecorator(dataFetcher, handlesSubscription);
            codeRegistry.dataFetcher(parent, fieldDefinition, dataFetcher);
            return TraversalControl.CONTINUE;
        }
    };

    private ContextDataFetcherDecorator(DataFetcher<?> delegate, boolean subscription) {
        Assert.notNull(delegate, (String)"'delegate' DataFetcher is required");
        this.delegate = delegate;
        this.subscription = subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(DataFetchingEnvironment environment) throws Exception {
        Object value;
        ContextView contextView = ReactorContextManager.getReactorContext(environment);
        try {
            ReactorContextManager.restoreThreadLocalValues(contextView);
            value = this.delegate.get(environment);
        }
        finally {
            ReactorContextManager.resetThreadLocalValues(contextView);
        }
        if (this.subscription) {
            return !contextView.isEmpty() ? Flux.from((Publisher)((Publisher)value)).contextWrite(contextView) : value;
        }
        if (value instanceof Flux) {
            value = ((Flux)value).collectList();
        }
        if (value instanceof Mono) {
            Mono valueMono = (Mono)value;
            if (!contextView.isEmpty()) {
                valueMono = valueMono.contextWrite(contextView);
            }
            value = valueMono.toFuture();
        }
        return value;
    }
}

