/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;

public class SourceMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return !BeanUtils.isSimpleValueType((Class)type) && !type.isArray() && !Collection.class.isAssignableFrom(type);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        Assert.isInstanceOf((Class)parameter.getParameterType(), (Object)source, (String)("The declared parameter of type '" + parameter.getParameterType() + "' does not match the type of the source Object '" + source.getClass() + "'."));
        return source;
    }
}

