/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.ContextValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContextValueMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterAnnotation(ContextValue.class) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        return ContextValueMethodArgumentResolver.resolveContextValue(parameter, environment.getLocalContext(), environment.getGraphQlContext());
    }

    @Nullable
    static Object resolveContextValue(MethodParameter parameter, @Nullable Object localContext, GraphQLContext graphQlContext) {
        ContextValue annotation = (ContextValue)parameter.getParameterAnnotation(ContextValue.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"Expected @ContextValue annotation");
        String name = ContextValueMethodArgumentResolver.getValueName(parameter, annotation);
        Class parameterType = parameter.getParameterType();
        Object value = null;
        if (localContext instanceof GraphQLContext) {
            value = ((GraphQLContext)localContext).get((Object)name);
        }
        if (value != null) {
            return ContextValueMethodArgumentResolver.wrapAsOptionalIfNecessary(value, parameterType);
        }
        value = graphQlContext.get((Object)name);
        if (value == null && annotation.required() && !parameterType.equals(Optional.class)) {
            throw new IllegalStateException("Missing required context value for " + parameter);
        }
        return ContextValueMethodArgumentResolver.wrapAsOptionalIfNecessary(value, parameterType);
    }

    private static String getValueName(MethodParameter parameter, ContextValue annotation) {
        if (StringUtils.hasText((String)annotation.name())) {
            return annotation.name();
        }
        String parameterName = parameter.getParameterName();
        if (parameterName != null) {
            return parameterName;
        }
        throw new IllegalArgumentException("Name for @ContextValue argument of type [" + parameter.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
    }

    @Nullable
    private static Object wrapAsOptionalIfNecessary(@Nullable Object value, Class<?> type) {
        return type.equals(Optional.class) ? Optional.ofNullable(value) : value;
    }
}

