/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public abstract class InvocableHandlerMethodSupport
extends HandlerMethod {
    private static final Object NO_VALUE = new Object();

    protected InvocableHandlerMethodSupport(HandlerMethod handlerMethod) {
        super(handlerMethod.createWithResolvedBean());
    }

    @Nullable
    protected Object doInvoke(Object ... argValues) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Arguments: " + Arrays.toString(argValues)));
        }
        Method method = this.getBridgedMethod();
        try {
            if (KotlinDetector.isSuspendingFunction((Method)method)) {
                return CoroutinesUtils.invokeSuspendingFunction((Method)method, (Object)this.getBean(), (Object[])argValues);
            }
            return method.invoke(this.getBean(), argValues);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(method, this.getBean(), argValues);
            String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
            return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError(text, argValues), ex));
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof Error || targetException instanceof Exception) {
                return Mono.error((Throwable)targetException);
            }
            return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError("Invocation failure", argValues), targetException));
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    protected Mono<Object[]> toArgsMono(Object[] args) {
        List monoList = Arrays.stream(args).map(arg -> {
            Mono argMono = arg instanceof Mono ? (Mono)arg : Mono.justOrEmpty((Object)arg);
            return argMono.defaultIfEmpty(NO_VALUE);
        }).collect(Collectors.toList());
        return Mono.zip(monoList, values -> Stream.of(values).map(value -> value != NO_VALUE ? value : null).toArray());
    }
}

