/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.client.ResponseMapGraphQlResponse;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpGraphQlTransport
implements GraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final WebClient webClient;

    HttpGraphQlTransport(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"WebClient is required");
        this.webClient = webClient;
    }

    @Override
    public Mono<GraphQlResponse> execute(GraphQlRequest request) {
        return ((WebClient.RequestBodySpec)this.webClient.post().contentType(MediaType.APPLICATION_GRAPHQL).accept(new MediaType[]{MediaType.APPLICATION_GRAPHQL, MediaType.APPLICATION_JSON})).bodyValue(request.toMap()).retrieve().bodyToMono(MAP_TYPE).map(ResponseMapGraphQlResponse::new);
    }

    @Override
    public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
        throw new UnsupportedOperationException("Subscriptions not supported over HTTP");
    }
}

