/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.DefaultTransportGraphQlClientBuilder;
import org.springframework.graphql.client.GraphQlClientInterceptor;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface GraphQlClient {
    public RequestSpec document(String var1);

    public RequestSpec documentName(String var1);

    public Builder<?> mutate();

    public static Builder<?> builder(GraphQlTransport transport) {
        return new DefaultTransportGraphQlClientBuilder(transport);
    }

    public static interface RetrieveSubscriptionSpec {
        public <D> Flux<D> toEntity(Class<D> var1);

        public <D> Flux<D> toEntity(ParameterizedTypeReference<D> var1);

        public <D> Flux<List<D>> toEntityList(Class<D> var1);

        public <D> Flux<List<D>> toEntityList(ParameterizedTypeReference<D> var1);
    }

    public static interface RetrieveSpec {
        public <D> Mono<D> toEntity(Class<D> var1);

        public <D> Mono<D> toEntity(ParameterizedTypeReference<D> var1);

        public <D> Mono<List<D>> toEntityList(Class<D> var1);

        public <D> Mono<List<D>> toEntityList(ParameterizedTypeReference<D> var1);
    }

    public static interface RequestSpec {
        public RequestSpec operationName(@Nullable String var1);

        public RequestSpec variable(String var1, @Nullable Object var2);

        public RequestSpec variables(Map<String, Object> var1);

        public RequestSpec attribute(String var1, Object var2);

        public RequestSpec attributes(Consumer<Map<String, Object>> var1);

        public RetrieveSpec retrieve(String var1);

        public RetrieveSubscriptionSpec retrieveSubscription(String var1);

        public Mono<ClientGraphQlResponse> execute();

        public Flux<ClientGraphQlResponse> executeSubscription();
    }

    public static interface Builder<B extends Builder<B>> {
        public B interceptor(GraphQlClientInterceptor ... var1);

        public B interceptors(Consumer<List<GraphQlClientInterceptor>> var1);

        public B documentSource(DocumentSource var1);

        public GraphQlClient build();
    }
}

