/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.util.function.Consumer;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.client.AbstractDelegatingGraphQlClient;
import org.springframework.graphql.client.AbstractGraphQlClientBuilder;
import org.springframework.graphql.client.CodecDelegate;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.RSocketGraphQlClient;
import org.springframework.graphql.client.RSocketGraphQlTransport;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

final class DefaultRSocketGraphQlClientBuilder
extends AbstractGraphQlClientBuilder<DefaultRSocketGraphQlClientBuilder>
implements RSocketGraphQlClient.Builder<DefaultRSocketGraphQlClientBuilder> {
    private final RSocketRequester.Builder requesterBuilder;
    @Nullable
    private ClientTransport clientTransport;
    private String route;

    DefaultRSocketGraphQlClientBuilder() {
        this(DefaultRSocketGraphQlClientBuilder.initRSocketRequestBuilder());
    }

    DefaultRSocketGraphQlClientBuilder(RSocketRequester.Builder requesterBuilder) {
        Assert.notNull((Object)requesterBuilder, (String)"RSocketRequester.Builder is required");
        this.requesterBuilder = requesterBuilder;
        this.route = "graphql";
    }

    private static RSocketRequester.Builder initRSocketRequestBuilder() {
        RSocketRequester.Builder requesterBuilder = RSocketRequester.builder().dataMimeType(MimeTypeUtils.APPLICATION_GRAPHQL);
        if (jackson2Present) {
            requesterBuilder.rsocketStrategies(RSocketStrategies.builder().encoder(new Encoder[]{AbstractGraphQlClientBuilder.DefaultJackson2Codecs.encoder()}).decoder(new Decoder[]{AbstractGraphQlClientBuilder.DefaultJackson2Codecs.decoder()}).build());
        }
        return requesterBuilder;
    }

    @Override
    public DefaultRSocketGraphQlClientBuilder tcp(String host, int port) {
        this.clientTransport = TcpClientTransport.create((String)host, (int)port);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlClientBuilder webSocket(URI uri) {
        this.clientTransport = WebsocketClientTransport.create((URI)uri);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlClientBuilder clientTransport(ClientTransport clientTransport) {
        this.clientTransport = clientTransport;
        return this;
    }

    @Override
    public DefaultRSocketGraphQlClientBuilder dataMimeType(MimeType dataMimeType) {
        this.requesterBuilder.dataMimeType(dataMimeType);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlClientBuilder route(String route) {
        Assert.notNull((Object)route, (String)"'route' is required");
        this.route = route;
        return this;
    }

    @Override
    public DefaultRSocketGraphQlClientBuilder rsocketRequester(Consumer<RSocketRequester.Builder> requesterConsumer) {
        requesterConsumer.accept(this.requesterBuilder);
        return this;
    }

    @Override
    public RSocketGraphQlClient build() {
        this.requesterBuilder.rsocketStrategies(builder -> {
            builder.decoders(decoders -> this.setJsonDecoder(CodecDelegate.findJsonDecoder(decoders)));
            builder.encoders(encoders -> this.setJsonEncoder(CodecDelegate.findJsonEncoder(encoders)));
        });
        Assert.state((this.clientTransport != null ? 1 : 0) != 0, (String)"Neither WebSocket nor TCP networking configured");
        RSocketRequester requester = this.requesterBuilder.transport(this.clientTransport);
        RSocketGraphQlTransport graphQlTransport = new RSocketGraphQlTransport(this.route, requester, this.getJsonDecoder());
        return new DefaultRSocketGraphQlClient(super.buildGraphQlClient(graphQlTransport), this.requesterBuilder, this.clientTransport, this.route, this.getBuilderInitializer());
    }

    private static class DefaultRSocketGraphQlClient
    extends AbstractDelegatingGraphQlClient
    implements RSocketGraphQlClient {
        private final RSocketRequester.Builder requesterBuilder;
        private final ClientTransport clientTransport;
        private final String route;
        private final Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer;

        DefaultRSocketGraphQlClient(GraphQlClient graphQlClient, RSocketRequester.Builder requesterBuilder, ClientTransport clientTransport, String route, Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer) {
            super(graphQlClient);
            this.requesterBuilder = requesterBuilder;
            this.clientTransport = clientTransport;
            this.route = route;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public RSocketGraphQlClient.Builder<?> mutate() {
            DefaultRSocketGraphQlClientBuilder builder = new DefaultRSocketGraphQlClientBuilder(this.requesterBuilder);
            builder.clientTransport(this.clientTransport);
            builder.route(this.route);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

