/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.test.tester.DefaultTransportGraphQlTesterBuilder;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;

public interface GraphQlTester {
    public Request<?> document(String var1);

    public Request<?> documentName(String var1);

    public Builder<?> mutate();

    public static Builder<?> builder(GraphQlTransport transport) {
        return new DefaultTransportGraphQlTesterBuilder(transport);
    }

    public static interface Subscription {
        default public <T> Flux<T> toFlux(String path, Class<T> entityType) {
            return this.toFlux().map(spec -> spec.path(path).entity(entityType).get());
        }

        public Flux<Response> toFlux();
    }

    public static interface Errors {
        public Errors filter(Predicate<ResponseError> var1);

        public Errors expect(Predicate<ResponseError> var1);

        public Traversable verify();

        public Traversable satisfy(Consumer<List<ResponseError>> var1);
    }

    public static interface EntityList<E>
    extends Entity<List<E>, EntityList<E>> {
        public EntityList<E> contains(E ... var1);

        public EntityList<E> doesNotContain(E ... var1);

        public EntityList<E> containsExactly(E ... var1);

        public EntityList<E> hasSize(int var1);

        public EntityList<E> hasSizeLessThan(int var1);

        public EntityList<E> hasSizeGreaterThan(int var1);
    }

    public static interface Entity<D, S extends Entity<D, S>>
    extends Traversable {
        public <T extends S> T isEqualTo(Object var1);

        public <T extends S> T isNotEqualTo(Object var1);

        public <T extends S> T isSameAs(Object var1);

        public <T extends S> T isNotSameAs(Object var1);

        public <T extends S> T matches(Predicate<D> var1);

        public <T extends S> T satisfies(Consumer<D> var1);

        public D get();
    }

    public static interface Path
    extends Traversable {
        public Path hasValue();

        public Path valueIsNull();

        public Path pathDoesNotExist();

        public <D> Entity<D, ?> entity(Class<D> var1);

        public <D> Entity<D, ?> entity(ParameterizedTypeReference<D> var1);

        public <D> EntityList<D> entityList(Class<D> var1);

        public <D> EntityList<D> entityList(ParameterizedTypeReference<D> var1);

        public Traversable matchesJson(String var1);

        public Traversable matchesJsonStrictly(String var1);
    }

    public static interface Response
    extends Traversable {
        public Errors errors();
    }

    public static interface Traversable {
        public Path path(String var1);

        public Path path(String var1, Consumer<Path> var2);
    }

    public static interface Request<T extends Request<T>> {
        public T operationName(@Nullable String var1);

        public T fragment(String var1);

        public T fragmentName(String var1);

        public T variable(String var1, @Nullable Object var2);

        public T variables(Map<String, Object> var1);

        public T extension(String var1, @Nullable Object var2);

        public Response execute();

        public void executeAndVerify();

        public Subscription executeSubscription();
    }

    public static interface Builder<B extends Builder<B>> {
        public B errorFilter(Predicate<ResponseError> var1);

        public B documentSource(DocumentSource var1);

        public B responseTimeout(Duration var1);

        public GraphQlTester build();
    }
}

