/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu.webmvc;

import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.AtomConverterInitializer;
import org.springframework.boot.autoconfigure.web.servlet.FormConverterInitializer;
import org.springframework.boot.autoconfigure.web.servlet.JacksonJsonConverterInitializer;
import org.springframework.boot.autoconfigure.web.servlet.ResourceConverterInitializer;
import org.springframework.boot.autoconfigure.web.servlet.RssConverterInitializer;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerInitializer;
import org.springframework.boot.autoconfigure.web.servlet.StringConverterInitializer;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.fu.jafu.AbstractDsl;
import org.springframework.fu.jafu.web.JacksonDsl;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;

public class WebMvcServerDsl
extends AbstractDsl {
    private final Consumer<WebMvcServerDsl> dsl;
    private ServerProperties serverProperties = new ServerProperties();
    private ResourceProperties resourceProperties = new ResourceProperties();
    private WebMvcProperties webMvcProperties = new WebMvcProperties();
    private boolean convertersConfigured = false;
    private int port = 8080;

    WebMvcServerDsl(Consumer<WebMvcServerDsl> dsl) {
        this.dsl = dsl;
    }

    public static ApplicationContextInitializer<GenericApplicationContext> webMvc() {
        return new WebMvcServerDsl(dsl -> {});
    }

    public static ApplicationContextInitializer<GenericApplicationContext> webMvc(Consumer<WebMvcServerDsl> dsl) {
        return new WebMvcServerDsl(dsl);
    }

    public WebMvcServerDsl port(int port) {
        this.port = port;
        return this;
    }

    public WebMvcServerDsl router(Consumer<RouterFunctions.Builder> routerDsl) {
        RouterFunctions.Builder builder = RouterFunctions.route();
        this.context.registerBean(BeanDefinitionReaderUtils.uniqueBeanName((String)RouterFunction.class.getName(), (BeanDefinitionRegistry)this.context), RouterFunction.class, () -> {
            routerDsl.accept(builder);
            return builder.build();
        }, new BeanDefinitionCustomizer[0]);
        return this;
    }

    public WebMvcServerDsl converters(Consumer<WebMvcServerConverterDsl> init) {
        new WebMvcServerConverterDsl(init).initialize(this.context);
        this.convertersConfigured = true;
        return this;
    }

    @Override
    public WebMvcServerDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
        return (WebMvcServerDsl)super.enable(dsl);
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
        context.registerBean(BeanDefinitionReaderUtils.uniqueBeanName((String)RouterFunction.class.getName(), (BeanDefinitionRegistry)context), RouterFunction.class, () -> RouterFunctions.route().resources("/**", (Resource)new ClassPathResource("static/")).build(), new BeanDefinitionCustomizer[0]);
        this.serverProperties.setPort(Integer.valueOf(this.port));
        this.serverProperties.getServlet().setRegisterDefaultServlet(false);
        if (!this.convertersConfigured) {
            new StringConverterInitializer().initialize(context);
            new ResourceConverterInitializer().initialize(context);
        }
        if (context.containsBeanDefinition("webHandler")) {
            throw new IllegalStateException("Only one webFlux per application is supported");
        }
        new ServletWebServerInitializer(this.serverProperties, this.webMvcProperties, this.resourceProperties).initialize(context);
    }

    public static class WebMvcServerConverterDsl
    extends AbstractDsl {
        private final Consumer<WebMvcServerConverterDsl> dsl;

        WebMvcServerConverterDsl(Consumer<WebMvcServerConverterDsl> dsl) {
            this.dsl = dsl;
        }

        @Override
        public WebMvcServerConverterDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
            return (WebMvcServerConverterDsl)super.enable(dsl);
        }

        @Override
        public void initialize(GenericApplicationContext context) {
            super.initialize(context);
            this.dsl.accept(this);
        }

        public WebMvcServerConverterDsl string() {
            new StringConverterInitializer().initialize(this.context);
            return this;
        }

        public WebMvcServerConverterDsl resource() {
            new ResourceConverterInitializer().initialize(this.context);
            return this;
        }

        public WebMvcServerConverterDsl form() {
            new FormConverterInitializer().initialize(this.context);
            return this;
        }

        public WebMvcServerConverterDsl jackson() {
            return this.jackson(dsl -> {});
        }

        public WebMvcServerConverterDsl jackson(Consumer<JacksonDsl> dsl) {
            new JacksonDsl(false, dsl).initialize(this.context);
            new JacksonJsonConverterInitializer().initialize(this.context);
            return this;
        }

        public WebMvcServerConverterDsl atom() {
            new AtomConverterInitializer().initialize(this.context);
            return this;
        }

        public WebMvcServerConverterDsl rss() {
            new RssConverterInitializer().initialize(this.context);
            return this;
        }
    }
}

