/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu.webflux;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.FormCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.JacksonJsonCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.MultipartCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.ProtobufCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.ReactiveWebServerInitializer;
import org.springframework.boot.autoconfigure.web.reactive.ResourceCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.StringCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.reactive.server.ConfigurableReactiveWebServerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.AbstractDsl;
import org.springframework.fu.jafu.web.JacksonDsl;
import org.springframework.fu.jafu.webflux.MustacheDsl;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.server.WebFilter;

public class WebFluxServerDsl
extends AbstractDsl {
    private final Consumer<WebFluxServerDsl> dsl;
    private ServerProperties serverProperties = new ServerProperties();
    private ResourceProperties resourceProperties = new ResourceProperties();
    private WebFluxProperties webFluxProperties = new WebFluxProperties();
    private boolean codecsConfigured = false;
    private int port = 8080;
    private ConfigurableReactiveWebServerFactory engine = null;

    WebFluxServerDsl(Consumer<WebFluxServerDsl> dsl) {
        this.dsl = dsl;
    }

    public static ApplicationContextInitializer<GenericApplicationContext> webFlux() {
        return new WebFluxServerDsl(dsl -> {});
    }

    public static ApplicationContextInitializer<GenericApplicationContext> webFlux(Consumer<WebFluxServerDsl> dsl) {
        return new WebFluxServerDsl(dsl);
    }

    public WebFluxServerDsl port(int port) {
        this.port = port;
        return this;
    }

    public WebFluxServerDsl engine(ConfigurableReactiveWebServerFactory engine) {
        this.engine = engine;
        return this;
    }

    public WebFluxServerDsl router(Consumer<RouterFunctions.Builder> routerDsl) {
        RouterFunctions.Builder builder = RouterFunctions.route();
        this.context.registerBean(BeanDefinitionReaderUtils.uniqueBeanName((String)RouterFunction.class.getName(), (BeanDefinitionRegistry)this.context), RouterFunction.class, () -> {
            routerDsl.accept(builder);
            return builder.build();
        }, new BeanDefinitionCustomizer[0]);
        return this;
    }

    public WebFluxServerDsl codecs(Consumer<WebFluxServerCodecDsl> init) {
        new WebFluxServerCodecDsl(init).initialize(this.context);
        this.codecsConfigured = true;
        return this;
    }

    public WebFluxServerDsl filter(Class<? extends WebFilter> clazz) {
        this.context.registerBean(BeanDefinitionReaderUtils.uniqueBeanName((String)clazz.getName(), (BeanDefinitionRegistry)this.context), clazz, new BeanDefinitionCustomizer[0]);
        return this;
    }

    public WebFluxServerDsl mustache() {
        return this.mustache(dsl -> {});
    }

    public WebFluxServerDsl mustache(Consumer<MustacheDsl> dsl) {
        new MustacheDsl(dsl).initialize(this.context);
        return this;
    }

    @Override
    public WebFluxServerDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
        return (WebFluxServerDsl)super.enable(dsl);
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
        if (this.engine == null) {
            this.engine = new NettyDelegate().get();
        }
        this.engine.setPort(this.port);
        if (!this.codecsConfigured) {
            new StringCodecInitializer(false, false).initialize(context);
            new ResourceCodecInitializer(false).initialize(context);
        }
        if (context.containsBeanDefinition("webHandler")) {
            throw new IllegalStateException("Only one webFlux per application is supported");
        }
        new ReactiveWebServerInitializer(this.serverProperties, this.resourceProperties, this.webFluxProperties, this.engine).initialize(context);
    }

    private static class NettyDelegate
    implements Supplier<ConfigurableReactiveWebServerFactory> {
        private NettyDelegate() {
        }

        @Override
        public ConfigurableReactiveWebServerFactory get() {
            return new NettyReactiveWebServerFactory();
        }
    }

    public static class WebFluxServerCodecDsl
    extends AbstractDsl {
        private final Consumer<WebFluxServerCodecDsl> dsl;

        WebFluxServerCodecDsl(Consumer<WebFluxServerCodecDsl> dsl) {
            this.dsl = dsl;
        }

        @Override
        public WebFluxServerCodecDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
            return (WebFluxServerCodecDsl)super.enable(dsl);
        }

        @Override
        public void initialize(GenericApplicationContext context) {
            super.initialize(context);
            this.dsl.accept(this);
        }

        public WebFluxServerCodecDsl string() {
            new StringCodecInitializer(false, false).initialize(this.context);
            return this;
        }

        public WebFluxServerCodecDsl string(boolean textPlainOnly) {
            new StringCodecInitializer(false, textPlainOnly).initialize(this.context);
            return this;
        }

        public WebFluxServerCodecDsl resource() {
            new ResourceCodecInitializer(false).initialize(this.context);
            return this;
        }

        public WebFluxServerCodecDsl protobuf() {
            new ProtobufCodecInitializer(false).initialize(this.context);
            return this;
        }

        public WebFluxServerCodecDsl form() {
            new FormCodecInitializer(false).initialize(this.context);
            return this;
        }

        public WebFluxServerCodecDsl multipart() {
            new MultipartCodecInitializer(false).initialize(this.context);
            return this;
        }

        public WebFluxServerCodecDsl jackson() {
            return this.jackson(dsl -> {});
        }

        public WebFluxServerCodecDsl jackson(Consumer<JacksonDsl> dsl) {
            new JacksonDsl(false, dsl).initialize(this.context);
            new JacksonJsonCodecInitializer(false).initialize(this.context);
            return this;
        }
    }
}

