/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu.webflux;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.web.reactive.FormCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.JacksonJsonCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.MultipartCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.ProtobufCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.ResourceCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.StringCodecInitializer;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ReactiveWebClientBuilderInitializer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.AbstractDsl;
import org.springframework.fu.jafu.web.JacksonDsl;

public class WebFluxClientDsl
extends AbstractDsl {
    private final Consumer<WebFluxClientDsl> dsl;
    private boolean codecsConfigured = false;
    private String baseUrl = null;

    private WebFluxClientDsl(Consumer<WebFluxClientDsl> dsl) {
        this.dsl = dsl;
    }

    public static ApplicationContextInitializer<GenericApplicationContext> webClient() {
        return new WebFluxClientDsl(webFluxClientDsl -> {});
    }

    public static ApplicationContextInitializer<GenericApplicationContext> webClient(Consumer<WebFluxClientDsl> dsl) {
        return new WebFluxClientDsl(dsl);
    }

    public WebFluxClientDsl baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public WebFluxClientDsl codecs(Consumer<WebFluxClientCodecDsl> init) {
        new WebFluxClientCodecDsl(init).initialize(this.context);
        this.codecsConfigured = true;
        return this;
    }

    @Override
    public WebFluxClientDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
        return (WebFluxClientDsl)super.enable(dsl);
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
        if (!this.codecsConfigured) {
            new StringCodecInitializer(true, false).initialize(context);
            new ResourceCodecInitializer(true).initialize(context);
        }
        new ReactiveWebClientBuilderInitializer(this.baseUrl).initialize(context);
    }

    public static class WebFluxClientCodecDsl
    extends AbstractDsl {
        private final Consumer<WebFluxClientCodecDsl> dsl;

        public WebFluxClientCodecDsl(Consumer<WebFluxClientCodecDsl> dsl) {
            this.dsl = dsl;
        }

        @Override
        public WebFluxClientCodecDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
            return (WebFluxClientCodecDsl)super.enable(dsl);
        }

        @Override
        public void initialize(GenericApplicationContext context) {
            super.initialize(context);
            this.dsl.accept(this);
        }

        public WebFluxClientCodecDsl string() {
            new StringCodecInitializer(true, false).initialize(this.context);
            return this;
        }

        public WebFluxClientCodecDsl string(boolean textPlainOnly) {
            new StringCodecInitializer(true, textPlainOnly).initialize(this.context);
            return this;
        }

        public WebFluxClientCodecDsl resource() {
            new ResourceCodecInitializer(true).initialize(this.context);
            return this;
        }

        public WebFluxClientCodecDsl protobuf() {
            new ProtobufCodecInitializer(true).initialize(this.context);
            return this;
        }

        public WebFluxClientCodecDsl form() {
            new FormCodecInitializer(true).initialize(this.context);
            return this;
        }

        public WebFluxClientCodecDsl multipart() {
            new MultipartCodecInitializer(true).initialize(this.context);
            return this;
        }

        public WebFluxClientCodecDsl jackson() {
            return this.jackson(dsl -> {});
        }

        public WebFluxClientCodecDsl jackson(Consumer<JacksonDsl> dsl) {
            new JacksonJsonCodecInitializer(true).initialize(this.context);
            new JacksonDsl(true, dsl).initialize(this.context);
            return this;
        }
    }
}

