/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu.web;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.jackson.JacksonInitializer;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.AbstractDsl;

public class JacksonDsl
extends AbstractDsl {
    private final boolean isClientCodec;
    private final Consumer<JacksonDsl> dsl;
    private final JacksonProperties properties = new JacksonProperties();

    public JacksonDsl(boolean isClientCodec, Consumer<JacksonDsl> dsl) {
        this.isClientCodec = isClientCodec;
        this.dsl = dsl;
    }

    @Override
    public JacksonDsl enable(ApplicationContextInitializer<GenericApplicationContext> dsl) {
        return (JacksonDsl)super.enable(dsl);
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
        new JacksonInitializer(this.properties).initialize(context);
    }

    public JacksonDsl dateFormat(String dateFormat) {
        this.properties.setDateFormat(dateFormat);
        return this;
    }

    public JacksonDsl propertyNamingStrategy(Class<PropertyNamingStrategy> strategy) {
        this.properties.setPropertyNamingStrategy(strategy.getName());
        return this;
    }

    public JacksonDsl defaultPropertyInclusion(JsonInclude.Include include) {
        this.properties.setDefaultPropertyInclusion(include);
        return this;
    }

    public JacksonDsl timeZone(TimeZone timeZone) {
        this.properties.setTimeZone(timeZone);
        return this;
    }

    public JacksonDsl locale(Locale locale) {
        this.properties.setLocale(locale);
        return this;
    }

    public JacksonDsl indentOutput(Boolean indentOutput) {
        this.properties.getSerialization().put(SerializationFeature.INDENT_OUTPUT, indentOutput);
        return this;
    }

    public JacksonDsl visibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        this.properties.getVisibility().put(propertyAccessor, visibility);
        return this;
    }

    public JacksonDsl enableSerializationFeature(SerializationFeature feature) {
        this.properties.getSerialization().put(feature, true);
        return this;
    }

    public JacksonDsl disableSerializationFeature(SerializationFeature feature) {
        this.properties.getSerialization().put(feature, false);
        return this;
    }

    public JacksonDsl enableDeserializationFeature(DeserializationFeature feature) {
        this.properties.getDeserialization().put(feature, true);
        return this;
    }

    public JacksonDsl disableDeserializationFeature(DeserializationFeature feature) {
        this.properties.getDeserialization().put(feature, false);
        return this;
    }

    public JacksonDsl enableMapperFeature(MapperFeature feature) {
        this.properties.getMapper().put(feature, true);
        return this;
    }

    public JacksonDsl disableMapperFeature(MapperFeature feature) {
        this.properties.getMapper().put(feature, false);
        return this;
    }

    public JacksonDsl enableGeneratorFeature(JsonGenerator.Feature feature) {
        this.properties.getGenerator().put(feature, true);
        return this;
    }

    public JacksonDsl disableGeneratorFeature(JsonGenerator.Feature feature) {
        this.properties.getGenerator().put(feature, false);
        return this;
    }
}

