/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu.r2dbc;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.data.r2dbc.PostgresqlDatabaseClientInitializer;
import org.springframework.boot.autoconfigure.data.r2dbc.PostgresqlR2dbcProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.AbstractDsl;

public class PostgresqlR2dbcDsl
extends AbstractDsl {
    private final Consumer<PostgresqlR2dbcDsl> dsl;
    private final PostgresqlR2dbcProperties properties = new PostgresqlR2dbcProperties();

    PostgresqlR2dbcDsl(Consumer<PostgresqlR2dbcDsl> dsl) {
        this.dsl = dsl;
    }

    public static ApplicationContextInitializer<GenericApplicationContext> r2dbcPostgresql() {
        return new PostgresqlR2dbcDsl(mongoDsl -> {});
    }

    public static ApplicationContextInitializer<GenericApplicationContext> r2dbcPostgresql(Consumer<PostgresqlR2dbcDsl> dsl) {
        return new PostgresqlR2dbcDsl(dsl);
    }

    public PostgresqlR2dbcDsl host(String host) {
        this.properties.setHost(host);
        return this;
    }

    public PostgresqlR2dbcDsl port(Integer port) {
        this.properties.setPort(port);
        return this;
    }

    public PostgresqlR2dbcDsl database(String database) {
        this.properties.setDatabase(database);
        return this;
    }

    public PostgresqlR2dbcDsl username(String username) {
        this.properties.setUsername(username);
        return this;
    }

    public PostgresqlR2dbcDsl password(String password) {
        this.properties.setPassword(password);
        return this;
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
        if (this.properties.getHost() == null) {
            this.properties.setHost("localhost");
        }
        if (this.properties.getPort() == null) {
            this.properties.setPort(Integer.valueOf(5432));
        }
        if (this.properties.getDatabase() == null) {
            this.properties.setDatabase("postgres");
        }
        if (this.properties.getUsername() == null) {
            this.properties.setUsername("postgres");
        }
        if (this.properties.getPassword() == null) {
            this.properties.setPassword("");
        }
        new PostgresqlDatabaseClientInitializer(this.properties).initialize(context);
    }
}

