/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu.mongo;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataInitializer;
import org.springframework.boot.autoconfigure.data.mongo.MongoReactiveDataInitializer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveInitializer;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoInitializer;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.AbstractDsl;

public class ReactiveMongoDsl
extends AbstractDsl {
    private final Consumer<ReactiveMongoDsl> dsl;
    private final MongoProperties properties = new MongoProperties();
    private boolean embedded = false;

    ReactiveMongoDsl(Consumer<ReactiveMongoDsl> dsl) {
        this.dsl = dsl;
    }

    public static ApplicationContextInitializer<GenericApplicationContext> reactiveMongo() {
        return new ReactiveMongoDsl(mongoDsl -> {});
    }

    public static ApplicationContextInitializer<GenericApplicationContext> reactiveMongo(Consumer<ReactiveMongoDsl> dsl) {
        return new ReactiveMongoDsl(dsl);
    }

    public ReactiveMongoDsl uri(String uri) {
        this.properties.setUri(uri);
        return this;
    }

    public ReactiveMongoDsl embedded() {
        new EmbeddedMongoDsl(this.properties, it -> {}).initialize(this.context);
        this.embedded = true;
        return this;
    }

    public ReactiveMongoDsl embedded(Consumer<EmbeddedMongoDsl> dsl) {
        new EmbeddedMongoDsl(this.properties, dsl).initialize(this.context);
        this.embedded = true;
        return this;
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
        if (this.properties.getUri() == null) {
            this.properties.setUri("mongodb://localhost/test");
        }
        new MongoDataInitializer(this.properties).initialize(context);
        new MongoReactiveDataInitializer(this.properties).initialize(context);
        new MongoReactiveInitializer(this.properties, this.embedded).initialize(context);
    }

    public static class EmbeddedMongoDsl
    extends AbstractDsl {
        private final Consumer<EmbeddedMongoDsl> dsl;
        private final MongoProperties mongoProperties;
        private final EmbeddedMongoProperties embeddedMongoProperties = new EmbeddedMongoProperties();

        EmbeddedMongoDsl(MongoProperties properties, Consumer<EmbeddedMongoDsl> dsl) {
            this.dsl = dsl;
            this.mongoProperties = properties;
        }

        public EmbeddedMongoDsl version(IFeatureAwareVersion version) {
            this.embeddedMongoProperties.setVersion(version.asInDownloadPath());
            return this;
        }

        @Override
        public void initialize(GenericApplicationContext context) {
            super.initialize(context);
            this.dsl.accept(this);
            new EmbeddedMongoInitializer(this.mongoProperties, this.embeddedMongoProperties).initialize(context);
        }
    }
}

