/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu;

import java.util.Arrays;
import java.util.function.Consumer;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.ApplicationDsl;

public abstract class JafuApplication {
    private final ApplicationContextInitializer<GenericApplicationContext> initializer;
    private ApplicationContextInitializer<GenericApplicationContext> customizer;

    protected JafuApplication(ApplicationContextInitializer<GenericApplicationContext> initializer) {
        this.initializer = initializer;
    }

    public ConfigurableApplicationContext run() {
        return this.run("", new String[0]);
    }

    public ConfigurableApplicationContext run(String profiles) {
        return this.run(profiles, new String[0]);
    }

    public ConfigurableApplicationContext run(String[] args) {
        return this.run("", args);
    }

    public ConfigurableApplicationContext run(String profiles, String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{JafuApplication.class}){

            protected void load(ApplicationContext context, Object[] sources) {
            }

            protected ConfigurableApplicationContext createApplicationContext() {
                return JafuApplication.this.createContext();
            }
        };
        if (!profiles.isEmpty()) {
            app.setAdditionalProfiles((String[])Arrays.stream(profiles.split(",")).map(it -> it.trim()).toArray(String[]::new));
        }
        app.addInitializers(new ApplicationContextInitializer[]{this.initializer});
        if (this.customizer != null) {
            app.addInitializers(new ApplicationContextInitializer[]{this.customizer});
        }
        System.setProperty("spring.backgroundpreinitializer.ignore", "true");
        return app.run(args);
    }

    public JafuApplication customize(Consumer<ApplicationDsl> customizer) {
        this.customizer = new ApplicationDsl(customizer);
        return this;
    }

    protected abstract ConfigurableApplicationContext createContext();
}

