/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.fu.jafu;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.fu.jafu.AbstractDsl;

public class BeanDefinitionDsl
extends AbstractDsl {
    private final Consumer<BeanDefinitionDsl> dsl;

    BeanDefinitionDsl(Consumer<BeanDefinitionDsl> dsl) {
        this.dsl = dsl;
    }

    public <T> BeanDefinitionDsl bean(Class<T> beanClass, BeanDefinitionCustomizer ... customizers) {
        String beanName = BeanDefinitionReaderUtils.uniqueBeanName((String)beanClass.getName(), (BeanDefinitionRegistry)this.context);
        this.context.registerBean(beanName, beanClass, customizers);
        return this;
    }

    public <T> BeanDefinitionDsl bean(String beanName, Class<T> beanClass, BeanDefinitionCustomizer ... customizers) {
        this.context.registerBean(beanName, beanClass, new BeanDefinitionCustomizer[0]);
        return this;
    }

    public <T> BeanDefinitionDsl bean(Class<T> beanClass, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        String beanName = BeanDefinitionReaderUtils.uniqueBeanName((String)beanClass.getName(), (BeanDefinitionRegistry)this.context);
        this.context.registerBean(beanName, beanClass, supplier, customizers);
        return this;
    }

    public <T> BeanDefinitionDsl bean(String beanName, Class<T> beanClass, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        this.context.registerBean(beanName, beanClass, supplier, customizers);
        return this;
    }

    @Override
    public void initialize(GenericApplicationContext context) {
        super.initialize(context);
        this.dsl.accept(this);
    }
}

