/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;

public class FunctionalPropertySourcesDeducer {
    private final ApplicationContext applicationContext;

    FunctionalPropertySourcesDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public PropertySources getPropertySources() {
        MutablePropertySources sources = this.extractEnvironmentPropertySources();
        if (sources != null) {
            return sources;
        }
        throw new IllegalStateException("Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
    }

    private MutablePropertySources extractEnvironmentPropertySources() {
        Environment environment = this.applicationContext.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)environment).getPropertySources();
        }
        return null;
    }
}

