/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.function.Function;
import org.springframework.boot.context.properties.FunctionalPropertySourcesDeducer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.UnboundElementsSourceFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySources;

public class FunctionalConfigurationPropertiesBinder {
    private final ConfigurableApplicationContext context;
    private final Binder binder;

    public FunctionalConfigurationPropertiesBinder(ConfigurableApplicationContext context) {
        PropertySources propertySources = new FunctionalPropertySourcesDeducer((ApplicationContext)context).getPropertySources();
        this.context = context;
        this.binder = new Binder(ConfigurationPropertySources.from((Iterable)propertySources), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Iterable)propertySources), null, registry -> context.getBeanFactory().copyRegisteredEditorsTo(registry));
    }

    public <T> BindResult<T> bind(String prefix, Bindable<T> target) {
        UnboundElementsSourceFilter filter = new UnboundElementsSourceFilter();
        NoUnboundElementsBindHandler handler = new NoUnboundElementsBindHandler((BindHandler)new IgnoreTopLevelConverterNotFoundBindHandler(), (Function)filter);
        return this.binder.bind(prefix, target, (BindHandler)handler);
    }
}

