/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import java.util.List;
import java.util.function.Supplier;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.TomcatServletWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.autoconfigure.web.servlet.WelcomePageHandlerMapping;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizerBeanPostProcessor;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.filter.OrderedHiddenHttpMethodFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ResourceLoader;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.RequestContextFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.function.support.HandlerFunctionAdapter;
import org.springframework.web.servlet.function.support.RouterFunctionMapping;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class ServletWebServerInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final ServerProperties serverProperties;
    private final WebMvcProperties webMvcProperties;
    private final ResourceProperties resourceProperties;

    public ServletWebServerInitializer(ServerProperties serverProperties, WebMvcProperties webMvcProperties, ResourceProperties resourceProperties) {
        this.serverProperties = serverProperties;
        this.webMvcProperties = webMvcProperties;
        this.resourceProperties = resourceProperties;
    }

    public void initialize(final GenericApplicationContext context) {
        context.registerBean("webServerFactoryCustomizerBeanPostProcessor", WebServerFactoryCustomizerBeanPostProcessor.class, WebServerFactoryCustomizerBeanPostProcessor::new, new BeanDefinitionCustomizer[0]);
        context.registerBean(WebMvcProperties.class, () -> this.webMvcProperties, new BeanDefinitionCustomizer[0]);
        context.registerBean(ServletWebServerFactoryAutoConfiguration.BeanPostProcessorsRegistrar.class, ServletWebServerFactoryAutoConfiguration.BeanPostProcessorsRegistrar::new, new BeanDefinitionCustomizer[0]);
        context.registerBean(TomcatServletWebServerFactory.class, () -> new ServletWebServerFactoryConfiguration.EmbeddedTomcat().tomcatServletWebServerFactory(context.getBeanProvider(TomcatConnectorCustomizer.class), context.getBeanProvider(TomcatContextCustomizer.class), context.getBeanProvider(ResolvableType.forClass(TomcatProtocolHandlerCustomizer.class))), new BeanDefinitionCustomizer[0]);
        ServletWebServerFactoryAutoConfiguration servletWebServerFactoryConfiguration = new ServletWebServerFactoryAutoConfiguration();
        context.registerBean(ServletWebServerFactoryCustomizer.class, () -> servletWebServerFactoryConfiguration.servletWebServerFactoryCustomizer(this.serverProperties), new BeanDefinitionCustomizer[0]);
        context.registerBean(TomcatServletWebServerFactoryCustomizer.class, () -> servletWebServerFactoryConfiguration.tomcatServletWebServerFactoryCustomizer(this.serverProperties), new BeanDefinitionCustomizer[0]);
        context.registerBean(FilterRegistrationBean.class, () -> ((ServletWebServerFactoryAutoConfiguration)servletWebServerFactoryConfiguration).forwardedHeaderFilter(), new BeanDefinitionCustomizer[0]);
        DispatcherServletAutoConfiguration.DispatcherServletConfiguration dispatcherServletConfiguration = new DispatcherServletAutoConfiguration.DispatcherServletConfiguration();
        context.registerBean("dispatcherServlet", DispatcherServlet.class, () -> dispatcherServletConfiguration.dispatcherServlet(this.webMvcProperties), new BeanDefinitionCustomizer[0]);
        context.registerBean("dispatcherServletRegistration", DispatcherServletRegistrationBean.class, () -> new DispatcherServletAutoConfiguration.DispatcherServletRegistrationConfiguration().dispatcherServletRegistration((DispatcherServlet)context.getBean("dispatcherServlet", DispatcherServlet.class), this.webMvcProperties, context.getBeanProvider(MultipartConfigElement.class)), new BeanDefinitionCustomizer[0]);
        WebMvcAutoConfiguration webMvcConfiguration = new WebMvcAutoConfiguration();
        context.registerBean(OrderedHiddenHttpMethodFilter.class, () -> ((WebMvcAutoConfiguration)webMvcConfiguration).hiddenHttpMethodFilter(), new BeanDefinitionCustomizer[0]);
        Supplier<WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter> webMvcConfigurationAdapter = new Supplier<WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter>(){
            private WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter configuration;

            @Override
            public WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter get() {
                if (this.configuration == null) {
                    this.configuration = new WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter(ServletWebServerInitializer.this.resourceProperties, ServletWebServerInitializer.this.webMvcProperties, (ListableBeanFactory)context, context.getBeanProvider(HttpMessageConverters.class), context.getBeanProvider(WebMvcAutoConfiguration.ResourceHandlerRegistrationCustomizer.class), context.getBeanProvider(DispatcherServletPath.class));
                    return this.configuration;
                }
                return this.configuration;
            }
        };
        context.registerBean(InternalResourceViewResolver.class, () -> ServletWebServerInitializer.lambda$initialize$6((Supplier)webMvcConfigurationAdapter), new BeanDefinitionCustomizer[0]);
        context.registerBean(BeanNameViewResolver.class, () -> ServletWebServerInitializer.lambda$initialize$7((Supplier)webMvcConfigurationAdapter), new BeanDefinitionCustomizer[0]);
        context.registerBean("viewResolver", ContentNegotiatingViewResolver.class, () -> ServletWebServerInitializer.lambda$initialize$8((Supplier)webMvcConfigurationAdapter, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(LocaleResolver.class, () -> ServletWebServerInitializer.lambda$initialize$9((Supplier)webMvcConfigurationAdapter), new BeanDefinitionCustomizer[0]);
        context.registerBean(RequestContextFilter.class, WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter::requestContextFilter, new BeanDefinitionCustomizer[0]);
        Supplier<WebMvcAutoConfiguration.EnableWebMvcConfiguration> enableWebMvcConfiguration = new Supplier<WebMvcAutoConfiguration.EnableWebMvcConfiguration>(){
            private WebMvcAutoConfiguration.EnableWebMvcConfiguration configuration;

            @Override
            public WebMvcAutoConfiguration.EnableWebMvcConfiguration get() {
                if (this.configuration == null) {
                    this.configuration = new EnableWebMvcConfigurationWrapper((ObjectProvider<WebMvcProperties>)context.getBeanProvider(WebMvcProperties.class), (ObjectProvider<WebMvcRegistrations>)context.getBeanProvider(WebMvcRegistrations.class), (ListableBeanFactory)context);
                    this.configuration.setApplicationContext((ApplicationContext)context);
                    this.configuration.setServletContext(((WebApplicationContext)context).getServletContext());
                    this.configuration.setResourceLoader((ResourceLoader)context);
                }
                return this.configuration;
            }
        };
        context.registerBean(FormattingConversionService.class, () -> ServletWebServerInitializer.lambda$initialize$10((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(Validator.class, () -> ServletWebServerInitializer.lambda$initialize$11((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(ContentNegotiationManager.class, () -> ServletWebServerInitializer.lambda$initialize$12((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(WebMvcAutoConfiguration.ResourceChainResourceHandlerRegistrationCustomizer.class, () -> new WebMvcAutoConfiguration.ResourceChainCustomizerConfiguration().resourceHandlerRegistrationCustomizer(), new BeanDefinitionCustomizer[0]);
        context.registerBean(PathMatcher.class, () -> ServletWebServerInitializer.lambda$initialize$14((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(UrlPathHelper.class, () -> ServletWebServerInitializer.lambda$initialize$15((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerMapping.class, () -> ServletWebServerInitializer.lambda$initialize$16((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(BeanNameUrlHandlerMapping.class, () -> ServletWebServerInitializer.lambda$initialize$17((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(RouterFunctionMapping.class, () -> ServletWebServerInitializer.lambda$initialize$18((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerMapping.class, () -> ServletWebServerInitializer.lambda$initialize$19((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(ResourceUrlProvider.class, () -> ServletWebServerInitializer.lambda$initialize$20((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerMapping.class, () -> ServletWebServerInitializer.lambda$initialize$21((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerFunctionAdapter.class, () -> ServletWebServerInitializer.lambda$initialize$22((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(HttpRequestHandlerAdapter.class, () -> ServletWebServerInitializer.lambda$initialize$23((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(SimpleControllerHandlerAdapter.class, () -> ServletWebServerInitializer.lambda$initialize$24((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerExceptionResolver.class, () -> ServletWebServerInitializer.lambda$initialize$25((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(ViewResolver.class, () -> ServletWebServerInitializer.lambda$initialize$26((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
        context.registerBean(HandlerMappingIntrospector.class, () -> ServletWebServerInitializer.lambda$initialize$27((Supplier)enableWebMvcConfiguration), new BeanDefinitionCustomizer[]{bd -> bd.setLazyInit(true)});
        context.registerBean(WelcomePageHandlerMapping.class, () -> ServletWebServerInitializer.lambda$initialize$29((Supplier)enableWebMvcConfiguration, context), new BeanDefinitionCustomizer[0]);
    }

    private static /* synthetic */ WelcomePageHandlerMapping lambda$initialize$29(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).welcomePageHandlerMapping((ApplicationContext)context, (FormattingConversionService)context.getBean(FormattingConversionService.class), (ResourceUrlProvider)context.getBean(ResourceUrlProvider.class));
    }

    private static /* synthetic */ HandlerMappingIntrospector lambda$initialize$27(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcHandlerMappingIntrospector();
    }

    private static /* synthetic */ ViewResolver lambda$initialize$26(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcViewResolver((ContentNegotiationManager)context.getBean(ContentNegotiationManager.class));
    }

    private static /* synthetic */ HandlerExceptionResolver lambda$initialize$25(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).handlerExceptionResolver((ContentNegotiationManager)context.getBean(ContentNegotiationManager.class));
    }

    private static /* synthetic */ SimpleControllerHandlerAdapter lambda$initialize$24(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).simpleControllerHandlerAdapter();
    }

    private static /* synthetic */ HttpRequestHandlerAdapter lambda$initialize$23(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).httpRequestHandlerAdapter();
    }

    private static /* synthetic */ HandlerFunctionAdapter lambda$initialize$22(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).handlerFunctionAdapter();
    }

    private static /* synthetic */ HandlerMapping lambda$initialize$21(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).defaultServletHandlerMapping();
    }

    private static /* synthetic */ ResourceUrlProvider lambda$initialize$20(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcResourceUrlProvider();
    }

    private static /* synthetic */ HandlerMapping lambda$initialize$19(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).resourceHandlerMapping((UrlPathHelper)context.getBean(UrlPathHelper.class), (PathMatcher)context.getBean(PathMatcher.class), (ContentNegotiationManager)context.getBean(ContentNegotiationManager.class), (FormattingConversionService)context.getBean(FormattingConversionService.class), (ResourceUrlProvider)context.getBean(ResourceUrlProvider.class));
    }

    private static /* synthetic */ RouterFunctionMapping lambda$initialize$18(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).routerFunctionMapping((FormattingConversionService)context.getBean(FormattingConversionService.class), (ResourceUrlProvider)context.getBean(ResourceUrlProvider.class));
    }

    private static /* synthetic */ BeanNameUrlHandlerMapping lambda$initialize$17(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).beanNameHandlerMapping((FormattingConversionService)context.getBean(FormattingConversionService.class), (ResourceUrlProvider)context.getBean(ResourceUrlProvider.class));
    }

    private static /* synthetic */ HandlerMapping lambda$initialize$16(Supplier enableWebMvcConfiguration, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).viewControllerHandlerMapping((PathMatcher)context.getBean(PathMatcher.class), (UrlPathHelper)context.getBean(UrlPathHelper.class), (FormattingConversionService)context.getBean(FormattingConversionService.class), (ResourceUrlProvider)context.getBean(ResourceUrlProvider.class));
    }

    private static /* synthetic */ UrlPathHelper lambda$initialize$15(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcUrlPathHelper();
    }

    private static /* synthetic */ PathMatcher lambda$initialize$14(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcPathMatcher();
    }

    private static /* synthetic */ ContentNegotiationManager lambda$initialize$12(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcContentNegotiationManager();
    }

    private static /* synthetic */ Validator lambda$initialize$11(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcValidator();
    }

    private static /* synthetic */ FormattingConversionService lambda$initialize$10(Supplier enableWebMvcConfiguration) {
        return ((WebMvcAutoConfiguration.EnableWebMvcConfiguration)enableWebMvcConfiguration.get()).mvcConversionService();
    }

    private static /* synthetic */ LocaleResolver lambda$initialize$9(Supplier webMvcConfigurationAdapter) {
        return ((WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter)webMvcConfigurationAdapter.get()).localeResolver();
    }

    private static /* synthetic */ ContentNegotiatingViewResolver lambda$initialize$8(Supplier webMvcConfigurationAdapter, GenericApplicationContext context) {
        return ((WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter)webMvcConfigurationAdapter.get()).viewResolver((BeanFactory)context);
    }

    private static /* synthetic */ BeanNameViewResolver lambda$initialize$7(Supplier webMvcConfigurationAdapter) {
        return ((WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter)webMvcConfigurationAdapter.get()).beanNameViewResolver();
    }

    private static /* synthetic */ InternalResourceViewResolver lambda$initialize$6(Supplier webMvcConfigurationAdapter) {
        return ((WebMvcAutoConfiguration.WebMvcAutoConfigurationAdapter)webMvcConfigurationAdapter.get()).defaultViewResolver();
    }

    private class EnableWebMvcConfigurationWrapper
    extends WebMvcAutoConfiguration.EnableWebMvcConfiguration {
        public EnableWebMvcConfigurationWrapper(ObjectProvider<WebMvcProperties> mvcPropertiesProvider, ObjectProvider<WebMvcRegistrations> mvcRegistrationsProvider, ListableBeanFactory beanFactory) {
            super(ServletWebServerInitializer.this.resourceProperties, mvcPropertiesProvider, mvcRegistrationsProvider, beanFactory);
        }

        protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            this.getApplicationContext().getBeanProvider(HttpMessageConverter.class).orderedStream().forEach(converters::add);
        }

        protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            exceptionResolvers.add((HandlerExceptionResolver)new DefaultHandlerExceptionResolver());
        }
    }
}

