/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

public class ReactiveWebClientBuilderInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final String baseUrl;

    public ReactiveWebClientBuilderInitializer(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void initialize(GenericApplicationContext context) {
        context.registerBean(WebClient.Builder.class, () -> new WebClientAutoConfiguration().webClientBuilder(context.getBeanProvider(WebClientCustomizer.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(DefaultWebClientCodecCustomizer.class, () -> new DefaultWebClientCodecCustomizer(this.baseUrl, new ArrayList<CodecCustomizer>(context.getBeansOfType(CodecCustomizer.class).values())), new BeanDefinitionCustomizer[0]);
    }

    public static class DefaultWebClientCodecCustomizer
    implements WebClientCustomizer {
        private final List<CodecCustomizer> codecCustomizers;
        private final String baseUrl;

        public DefaultWebClientCodecCustomizer(String baseUrl, List<CodecCustomizer> codecCustomizers) {
            this.codecCustomizers = codecCustomizers;
            this.baseUrl = baseUrl;
        }

        public void customize(WebClient.Builder builder) {
            builder.exchangeStrategies(ExchangeStrategies.empty().codecs(codecs -> this.codecCustomizers.forEach(customizer -> customizer.customize((CodecConfigurer)codecs))).build());
            if (this.baseUrl != null) {
                builder.baseUrl(this.baseUrl);
            }
        }
    }
}

