/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import java.util.ArrayList;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.ReactiveWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.reactive.ResourceHandlerRegistrationCustomizer;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxRegistrations;
import org.springframework.boot.autoconfigure.web.reactive.error.ErrorWebFluxAutoConfiguration;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.boot.web.reactive.error.DefaultErrorAttributes;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.server.ConfigurableReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizerBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.validation.Validator;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.server.support.HandlerFunctionAdapter;
import org.springframework.web.reactive.function.server.support.RouterFunctionMapping;
import org.springframework.web.reactive.function.server.support.ServerResponseResultHandler;
import org.springframework.web.reactive.result.SimpleHandlerAdapter;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.view.ViewResolutionResultHandler;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import org.springframework.web.server.i18n.LocaleContextResolver;

public class ReactiveWebServerInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final ServerProperties serverProperties;
    private final ResourceProperties resourceProperties;
    private final ConfigurableReactiveWebServerFactory serverFactory;
    private final WebFluxProperties webFluxProperties;

    public ReactiveWebServerInitializer(ServerProperties serverProperties, ResourceProperties resourceProperties, WebFluxProperties webFluxProperties, ConfigurableReactiveWebServerFactory serverFactory) {
        this.serverProperties = serverProperties;
        this.resourceProperties = resourceProperties;
        this.webFluxProperties = webFluxProperties;
        this.serverFactory = serverFactory;
    }

    public void initialize(GenericApplicationContext context) {
        context.registerBean("webServerFactoryCustomizerBeanPostProcessor", WebServerFactoryCustomizerBeanPostProcessor.class, WebServerFactoryCustomizerBeanPostProcessor::new, new BeanDefinitionCustomizer[0]);
        context.registerBean(ReactiveWebServerFactoryCustomizer.class, () -> new ReactiveWebServerFactoryCustomizer(this.serverProperties), new BeanDefinitionCustomizer[0]);
        context.registerBean(ConfigurableReactiveWebServerFactory.class, () -> this.serverFactory, new BeanDefinitionCustomizer[0]);
        context.registerBean(ErrorAttributes.class, () -> new DefaultErrorAttributes(this.serverProperties.getError().isIncludeException()), new BeanDefinitionCustomizer[0]);
        context.registerBean(ErrorWebExceptionHandler.class, () -> {
            ErrorWebFluxAutoConfiguration errorConfiguration = new ErrorWebFluxAutoConfiguration(this.serverProperties);
            return errorConfiguration.errorWebExceptionHandler((ErrorAttributes)context.getBean(ErrorAttributes.class), this.resourceProperties, context.getBeanProvider(ViewResolver.class), (ServerCodecConfigurer)context.getBean("serverCodecConfigurer", ServerCodecConfigurer.class), (ApplicationContext)context);
        }, new BeanDefinitionCustomizer[0]);
        context.registerBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class, () -> new EnableWebFluxConfigurationWrapper(context, this.webFluxProperties), new BeanDefinitionCustomizer[0]);
        context.registerBean("localeContextResolver", LocaleContextResolver.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean(EnableWebFluxConfigurationWrapper.class)))).localeContextResolver(), new BeanDefinitionCustomizer[0]);
        context.registerBean("responseStatusExceptionHandler", WebExceptionHandler.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).responseStatusExceptionHandler(), new BeanDefinitionCustomizer[0]);
        context.registerBean(RouterFunctionMapping.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).routerFunctionMapping((ServerCodecConfigurer)context.getBean("serverCodecConfigurer", ServerCodecConfigurer.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean("serverCodecConfigurer", ServerCodecConfigurer.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).serverCodecConfigurer(), new BeanDefinitionCustomizer[0]);
        context.registerBean("webFluxAdapterRegistry", ReactiveAdapterRegistry.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).webFluxAdapterRegistry(), new BeanDefinitionCustomizer[0]);
        context.registerBean("handlerFunctionAdapter", HandlerFunctionAdapter.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).handlerFunctionAdapter(), new BeanDefinitionCustomizer[0]);
        context.registerBean("webFluxContentTypeResolver", RequestedContentTypeResolver.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).webFluxContentTypeResolver(), new BeanDefinitionCustomizer[0]);
        context.registerBean("webFluxConversionService", FormattingConversionService.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).webFluxConversionService(), new BeanDefinitionCustomizer[0]);
        context.registerBean("serverResponseResultHandler", ServerResponseResultHandler.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).serverResponseResultHandler((ServerCodecConfigurer)context.getBean("serverCodecConfigurer", ServerCodecConfigurer.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean("simpleHandlerAdapter", SimpleHandlerAdapter.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).simpleHandlerAdapter(), new BeanDefinitionCustomizer[0]);
        context.registerBean("viewResolutionResultHandler", ViewResolutionResultHandler.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).viewResolutionResultHandler((ReactiveAdapterRegistry)context.getBean("webFluxAdapterRegistry", ReactiveAdapterRegistry.class), (RequestedContentTypeResolver)context.getBean("webFluxContentTypeResolver", RequestedContentTypeResolver.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean("webFluxValidator", Validator.class, () -> ((EnableWebFluxConfigurationWrapper)((Object)((Object)context.getBean("fuWebFluxConfiguration", EnableWebFluxConfigurationWrapper.class)))).webFluxValidator(), new BeanDefinitionCustomizer[0]);
        context.registerBean(HttpHandler.class, () -> WebHttpHandlerBuilder.applicationContext((ApplicationContext)context).build(), new BeanDefinitionCustomizer[0]);
        context.registerBean("webHandler", DispatcherHandler.class, DispatcherHandler::new, new BeanDefinitionCustomizer[0]);
        context.registerBean(WebFluxAutoConfiguration.WebFluxConfig.class, () -> new WebFluxAutoConfiguration.WebFluxConfig(this.resourceProperties, this.webFluxProperties, (ListableBeanFactory)context, context.getBeanProvider(HandlerMethodArgumentResolver.class), context.getBeanProvider(CodecCustomizer.class), context.getBeanProvider(ResourceHandlerRegistrationCustomizer.class), context.getBeanProvider(ViewResolver.class)), new BeanDefinitionCustomizer[0]);
    }

    private class EnableWebFluxConfigurationWrapper
    extends WebFluxAutoConfiguration.EnableWebFluxConfiguration {
        public EnableWebFluxConfigurationWrapper(GenericApplicationContext context, WebFluxProperties webFluxProperties) {
            super(webFluxProperties, context.getBeanProvider(WebFluxRegistrations.class));
            this.setConfigurers(new ArrayList(context.getBeansOfType(WebFluxConfigurer.class).values()));
        }

        public ServerCodecConfigurer serverCodecConfigurer() {
            ServerCodecConfigurer configurer = ServerCodecConfigurer.create();
            configurer.registerDefaults(false);
            this.getApplicationContext().getBeanProvider(CodecCustomizer.class).forEach(customizer -> customizer.customize((CodecConfigurer)configurer));
            return configurer;
        }
    }
}

