/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.web.reactive.AbstractCodecInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;

public class JacksonJsonCodecInitializer
extends AbstractCodecInitializer {
    public JacksonJsonCodecInitializer(boolean isClientCodec) {
        super(isClientCodec);
    }

    @Override
    protected void register(GenericApplicationContext context, CodecConfigurer configurer) {
        ObjectMapper mapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        Jackson2JsonEncoder encoder = new Jackson2JsonEncoder(mapper, new MimeType[0]);
        configurer.customCodecs().decoder((Decoder)new Jackson2JsonDecoder(mapper, new MimeType[0]));
        configurer.customCodecs().encoder((Encoder)encoder);
        configurer.customCodecs().writer((HttpMessageWriter)new ServerSentEventHttpMessageWriter((Encoder)encoder));
    }
}

