/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import java.util.Arrays;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientCodecCustomizer;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.codec.CodecConfigurer;

public abstract class AbstractCodecInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    protected final boolean isClientCodec;

    public AbstractCodecInitializer(boolean isClientCodec) {
        this.isClientCodec = isClientCodec;
    }

    public void initialize(GenericApplicationContext context) {
        if (this.isClientCodec) {
            context.registerBean(BeanDefinitionReaderUtils.uniqueBeanName((String)WebClientCodecCustomizer.class.getName(), (BeanDefinitionRegistry)context), WebClientCodecCustomizer.class, () -> new WebClientCodecCustomizer(Arrays.asList(configurer -> this.register(context, configurer))), new BeanDefinitionCustomizer[0]);
        } else {
            context.registerBean(BeanDefinitionReaderUtils.uniqueBeanName((String)CodecCustomizer.class.getName(), (BeanDefinitionRegistry)context), CodecCustomizer.class, () -> configurer -> this.register(context, configurer), new BeanDefinitionCustomizer[0]);
        }
    }

    protected abstract void register(GenericApplicationContext var1, CodecConfigurer var2);
}

