/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.Mustache;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.mustache.MustacheAutoConfiguration;
import org.springframework.boot.autoconfigure.mustache.MustacheProperties;
import org.springframework.boot.autoconfigure.mustache.MustacheResourceTemplateLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;

public class MustacheInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MustacheProperties properties;

    public MustacheInitializer(MustacheProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        MustacheAutoConfiguration configuration = new MustacheAutoConfiguration(this.properties, (ApplicationContext)context);
        context.registerBean(MustacheResourceTemplateLoader.class, () -> ((MustacheAutoConfiguration)configuration).mustacheTemplateLoader(), new BeanDefinitionCustomizer[0]);
        context.registerBean(Mustache.Compiler.class, () -> configuration.mustacheCompiler((Mustache.TemplateLoader)context.getBean(Mustache.TemplateLoader.class), (Environment)context.getEnvironment()), new BeanDefinitionCustomizer[0]);
    }
}

