/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo.embedded;

import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import java.io.IOException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.embedded.DownloadConfigBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;

public class EmbeddedMongoInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MongoProperties properties;
    private final EmbeddedMongoProperties embeddedProperties;

    public EmbeddedMongoInitializer(MongoProperties mongoProperties, EmbeddedMongoProperties embeddedProperties) {
        this.properties = mongoProperties;
        this.embeddedProperties = embeddedProperties;
    }

    public void initialize(GenericApplicationContext context) {
        EmbeddedMongoAutoConfiguration configuration = new EmbeddedMongoAutoConfiguration(this.properties, this.embeddedProperties);
        context.registerBean(IMongodConfig.class, () -> {
            try {
                return configuration.embeddedMongoConfiguration(this.embeddedProperties);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }, new BeanDefinitionCustomizer[0]);
        context.registerBean("embeddedMongoServer", MongodExecutable.class, () -> {
            try {
                return configuration.embeddedMongoServer((IMongodConfig)context.getBean(IMongodConfig.class), (IRuntimeConfig)context.getBean(IRuntimeConfig.class), (ApplicationContext)context);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }, new BeanDefinitionCustomizer[]{definition -> {
            definition.setInitMethodName("start");
            definition.setDestroyMethodName("stop");
        }});
        context.registerBean(IRuntimeConfig.class, () -> new EmbeddedMongoAutoConfiguration.RuntimeConfigConfiguration().embeddedMongoRuntimeConfig(context.getBeanProvider(DownloadConfigBuilderCustomizer.class)), new BeanDefinitionCustomizer[0]);
    }
}

