/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.MongoReactiveAutoConfiguration;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;

public class MongoReactiveInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MongoProperties properties;
    private final boolean embeddedServer;

    public MongoReactiveInitializer(MongoProperties properties, boolean embeddedServer) {
        this.properties = properties;
        this.embeddedServer = embeddedServer;
    }

    public void initialize(GenericApplicationContext context) {
        context.registerBean(MongoClientSettingsBuilderCustomizer.class, () -> new MongoReactiveAutoConfiguration.NettyDriverConfiguration().nettyDriverCustomizer(context.getDefaultListableBeanFactory().getBeanProvider(MongoClientSettings.class)), new BeanDefinitionCustomizer[0]);
        MongoReactiveAutoConfiguration configuration = new MongoReactiveAutoConfiguration();
        context.registerBean(MongoClient.class, () -> configuration.reactiveStreamsMongoClient(this.properties, (Environment)context.getEnvironment(), context.getBeanProvider(MongoClientSettingsBuilderCustomizer.class), context.getBeanProvider(MongoClientSettings.class)), new BeanDefinitionCustomizer[]{definition -> {
            if (this.embeddedServer) {
                definition.setDependsOn(new String[]{"embeddedMongoServer"});
            }
        }});
    }
}

