/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class JacksonInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final JacksonProperties properties;

    public JacksonInitializer(JacksonProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        context.registerBean(Jackson2ObjectMapperBuilderCustomizer.class, () -> new JacksonAutoConfiguration.Jackson2ObjectMapperBuilderCustomizerConfiguration().standardJacksonObjectMapperBuilderCustomizer((ApplicationContext)context, this.properties), new BeanDefinitionCustomizer[0]);
        JacksonAutoConfiguration.JacksonObjectMapperBuilderConfiguration configuration = new JacksonAutoConfiguration.JacksonObjectMapperBuilderConfiguration();
        context.registerBean(Jackson2ObjectMapperBuilder.class, () -> configuration.jacksonObjectMapperBuilder((ApplicationContext)context, new ArrayList(context.getBeansOfType(Jackson2ObjectMapperBuilderCustomizer.class).values())), new BeanDefinitionCustomizer[0]);
        context.registerBean(ObjectMapper.class, () -> new JacksonAutoConfiguration.JacksonObjectMapperConfiguration().jacksonObjectMapper((Jackson2ObjectMapperBuilder)context.getBean(Jackson2ObjectMapperBuilder.class)), new BeanDefinitionCustomizer[0]);
    }
}

