/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;

public class SentinelInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final RedisProperties.Sentinel sentinel;

    public SentinelInitializer(RedisProperties.Sentinel sentinel) {
        this.sentinel = sentinel;
    }

    public void initialize(GenericApplicationContext context) {
        if (this.sentinel != null) {
            context.registerBean(RedisSentinelConfiguration.class, this::getRedisSentinelConfiguration, new BeanDefinitionCustomizer[0]);
        }
    }

    @NotNull
    private RedisSentinelConfiguration getRedisSentinelConfiguration() {
        return new RedisSentinelConfiguration(this.sentinel.getMaster(), new HashSet(this.sentinel.getNodes()));
    }
}

