/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.net.UnknownHostException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public void initialize(GenericApplicationContext context) {
        RedisAutoConfiguration redisAutoConfiguration = new RedisAutoConfiguration();
        context.registerBean("redisTemplate", RedisTemplate.class, () -> {
            try {
                return redisAutoConfiguration.redisTemplate((RedisConnectionFactory)context.getBean(RedisConnectionFactory.class));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }, new BeanDefinitionCustomizer[]{definition -> ((RootBeanDefinition)definition).setTargetType(ResolvableType.forClassWithGenerics(RedisTemplate.class, (Class[])new Class[]{Object.class, Object.class}))});
        context.registerBean("stringRedisTemplate", StringRedisTemplate.class, () -> {
            try {
                return redisAutoConfiguration.stringRedisTemplate((RedisConnectionFactory)context.getBean(RedisConnectionFactory.class));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }, new BeanDefinitionCustomizer[0]);
    }
}

