/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.net.UnknownHostException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.LettuceConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

public class LettuceRedisInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final RedisProperties redisProperties;

    public LettuceRedisInitializer(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }

    public void initialize(GenericApplicationContext context) {
        context.registerBean(RedisConnectionFactory.class, () -> this.getLettuceConnectionFactory(context), new BeanDefinitionCustomizer[0]);
        context.registerBean(ReactiveRedisConnectionFactory.class, () -> this.getLettuceConnectionFactory(context), new BeanDefinitionCustomizer[0]);
    }

    private LettuceConnectionFactory getLettuceConnectionFactory(GenericApplicationContext context) {
        LettuceConnectionConfiguration configuration = new LettuceConnectionConfiguration(this.redisProperties, context.getBeanProvider(RedisSentinelConfiguration.class), context.getBeanProvider(RedisClusterConfiguration.class));
        DefaultClientResources clientResources = DefaultClientResources.create();
        try {
            return configuration.redisConnectionFactory(context.getBeanProvider(LettuceClientConfigurationBuilderCustomizer.class), (ClientResources)clientResources);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

