/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.net.UnknownHostException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.JedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class JedisRedisInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final RedisProperties redisProperties;

    public JedisRedisInitializer(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }

    public void initialize(GenericApplicationContext context) {
        if (this.redisProperties.getJedis().getPool() != null) {
            context.registerBean(RedisConnectionFactory.class, () -> this.getJedisConnectionFactory(context), new BeanDefinitionCustomizer[0]);
        }
    }

    private JedisConnectionFactory getJedisConnectionFactory(GenericApplicationContext context) {
        JedisConnectionConfiguration configuration = new JedisConnectionConfiguration(this.redisProperties, context.getBeanProvider(RedisSentinelConfiguration.class), context.getBeanProvider(RedisClusterConfiguration.class));
        try {
            return configuration.redisConnectionFactory(context.getBeanProvider(JedisClientConfigurationBuilderCustomizer.class));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

