/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.redis.connection.RedisClusterConfiguration;

public class ClusterInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final RedisProperties.Cluster cluster;

    public ClusterInitializer(RedisProperties.Cluster cluster) {
        this.cluster = cluster;
    }

    public void initialize(GenericApplicationContext context) {
        if (this.cluster != null) {
            context.registerBean(RedisClusterConfiguration.class, this::getRedisClusterConfiguration, new BeanDefinitionCustomizer[0]);
        }
    }

    @NotNull
    private RedisClusterConfiguration getRedisClusterConfiguration() {
        RedisClusterConfiguration configuration = new RedisClusterConfiguration((Collection)this.cluster.getNodes());
        configuration.setMaxRedirects(this.cluster.getMaxRedirects().intValue());
        return configuration;
    }
}

