/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.r2dbc;

import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.r2dbc.PostgresqlR2dbcProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.r2dbc.core.DatabaseClient;

public class PostgresqlDatabaseClientInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final PostgresqlR2dbcProperties properties;

    public PostgresqlDatabaseClientInitializer(PostgresqlR2dbcProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        PostgresqlConnectionConfiguration configuration = PostgresqlConnectionConfiguration.builder().host(this.properties.getHost()).port(this.properties.getPort().intValue()).database(this.properties.getDatabase()).username(this.properties.getUsername()).password((CharSequence)this.properties.getPassword()).build();
        context.registerBean(DatabaseClient.class, () -> DatabaseClient.builder().connectionFactory((ConnectionFactory)new PostgresqlConnectionFactory(configuration)).build(), new BeanDefinitionCustomizer[0]);
    }
}

