/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.r2dbc;

import com.github.jasync.r2dbc.mysql.JasyncConnectionFactory;
import com.github.jasync.sql.db.mysql.pool.MySQLConnectionFactory;
import com.github.jasync.sql.db.mysql.util.URLParser;
import io.r2dbc.spi.ConnectionFactory;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.r2dbc.MysqlR2dbcProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.r2dbc.core.DatabaseClient;

public class MysqlDatabaseClientInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MysqlR2dbcProperties properties;

    public MysqlDatabaseClientInitializer(MysqlR2dbcProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        JasyncConnectionFactory jasyncConnectionFactory = new JasyncConnectionFactory(new MySQLConnectionFactory(URLParser.INSTANCE.parseOrDie(this.properties.getUrl(), StandardCharsets.UTF_8)));
        context.registerBean(DatabaseClient.class, () -> DatabaseClient.builder().connectionFactory((ConnectionFactory)jasyncConnectionFactory).build(), new BeanDefinitionCustomizer[0]);
    }
}

