/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.r2dbc;

import io.r2dbc.mssql.MssqlConnectionConfiguration;
import io.r2dbc.mssql.MssqlConnectionFactory;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.r2dbc.MssqlR2dbcProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.r2dbc.core.DatabaseClient;

public class MssqlDatabaseClientInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MssqlR2dbcProperties properties;

    public MssqlDatabaseClientInitializer(MssqlR2dbcProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        MssqlConnectionConfiguration.Builder builder = MssqlConnectionConfiguration.builder().host(this.properties.getHost()).port(this.properties.getPort().intValue()).database(this.properties.getDatabase()).username(this.properties.getUsername()).password((CharSequence)this.properties.getPassword()).connectTimeout(this.properties.getConnectTimeout()).preferCursoredExecution(this.properties.isPreferCursoredExecution());
        if (this.properties.isSsl()) {
            builder.enableSsl();
        }
        MssqlConnectionConfiguration configuration = builder.build();
        context.registerBean(DatabaseClient.class, () -> DatabaseClient.builder().connectionFactory((ConnectionFactory)new MssqlConnectionFactory(configuration)).build(), new BeanDefinitionCustomizer[0]);
    }
}

