/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.r2dbc;

import io.r2dbc.h2.H2ConnectionConfiguration;
import io.r2dbc.h2.H2ConnectionFactory;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.r2dbc.H2R2dbcProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.r2dbc.core.DatabaseClient;

public class H2DatabaseClientInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final H2R2dbcProperties properties;

    public H2DatabaseClientInitializer(H2R2dbcProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        H2ConnectionConfiguration configuration = H2ConnectionConfiguration.builder().url(this.properties.getUrl()).username(this.properties.getUsername()).password((CharSequence)this.properties.getPassword()).build();
        context.registerBean(DatabaseClient.class, () -> DatabaseClient.builder().connectionFactory((ConnectionFactory)new H2ConnectionFactory(configuration)).build(), new BeanDefinitionCustomizer[0]);
    }
}

