/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.mongo;

import com.mongodb.reactivestreams.client.MongoClient;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.mongo.MongoReactiveDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

public class MongoReactiveDataInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MongoProperties properties;

    public MongoReactiveDataInitializer(MongoProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        MongoReactiveDataAutoConfiguration configuration = new MongoReactiveDataAutoConfiguration();
        context.registerBean(MappingMongoConverter.class, () -> configuration.mappingMongoConverter((MongoMappingContext)context.getBean(MongoMappingContext.class), (MongoCustomConversions)context.getBean(MongoCustomConversions.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(SimpleReactiveMongoDatabaseFactory.class, () -> configuration.reactiveMongoDatabaseFactory(this.properties, (MongoClient)context.getBean(MongoClient.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(ReactiveMongoTemplate.class, () -> configuration.reactiveMongoTemplate((ReactiveMongoDatabaseFactory)context.getBean(ReactiveMongoDatabaseFactory.class), (MongoConverter)context.getBean(MongoConverter.class)), new BeanDefinitionCustomizer[0]);
    }
}

