/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.mongo;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

public class MongoDataInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final MongoProperties properties;

    public MongoDataInitializer(MongoProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        MongoDataConfiguration dataConfiguration = new MongoDataConfiguration();
        context.registerBean(MongoCustomConversions.class, () -> ((MongoDataConfiguration)dataConfiguration).mongoCustomConversions(), new BeanDefinitionCustomizer[0]);
        context.registerBean(MongoMappingContext.class, () -> {
            try {
                return dataConfiguration.mongoMappingContext((ApplicationContext)context, this.properties, (MongoCustomConversions)context.getBean(MongoCustomConversions.class));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }, new BeanDefinitionCustomizer[0]);
        context.registerBean(MongoCustomConversions.class, () -> ((MongoDataConfiguration)dataConfiguration).mongoCustomConversions(), new BeanDefinitionCustomizer[0]);
    }
}

