/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.data.cassandra.CassandraReactiveDataAutoConfiguration;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;

public class CassandraReactiveDataInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public void initialize(GenericApplicationContext context) {
        CassandraReactiveDataAutoConfiguration configuration = new CassandraReactiveDataAutoConfiguration();
        context.registerBean(ReactiveSession.class, () -> configuration.reactiveCassandraSession((CqlSession)context.getBean(CqlSession.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(ReactiveSessionFactory.class, () -> configuration.reactiveCassandraSessionFactory((ReactiveSession)context.getBean(ReactiveSession.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(ReactiveCassandraTemplate.class, () -> configuration.reactiveCassandraTemplate((ReactiveSession)context.getBean(ReactiveSession.class), (CassandraConverter)context.getBean(CassandraConverter.class)), new BeanDefinitionCustomizer[0]);
    }
}

