/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.data.cassandra.CassandraDataAutoConfiguration;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.SessionFactoryFactoryBean;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;

public class CassandraDataInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final CassandraProperties properties;

    public CassandraDataInitializer(CassandraProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        Supplier<CassandraDataAutoConfiguration> configurationSupplier = () -> new CassandraDataAutoConfiguration((CqlSession)context.getBean(CqlSession.class));
        context.registerBean(CassandraCustomConversions.class, () -> ((CassandraDataAutoConfiguration)configurationSupplier.get()).cassandraCustomConversions(), new BeanDefinitionCustomizer[0]);
        context.registerBean(CassandraMappingContext.class, () -> this.getCassandraMappingContext(context, configurationSupplier), new BeanDefinitionCustomizer[0]);
        context.registerBean(CassandraConverter.class, () -> ((CassandraDataAutoConfiguration)configurationSupplier.get()).cassandraConverter((CassandraMappingContext)context.getBean(CassandraMappingContext.class), (CassandraCustomConversions)context.getBean(CassandraCustomConversions.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(SessionFactoryFactoryBean.class, () -> this.getCassandraSessionFactoryBean(context, configurationSupplier), new BeanDefinitionCustomizer[0]);
        context.registerBean(CassandraTemplate.class, () -> this.getCassandraTemplate(context, configurationSupplier), new BeanDefinitionCustomizer[0]);
    }

    private CassandraMappingContext getCassandraMappingContext(GenericApplicationContext context, Supplier<CassandraDataAutoConfiguration> configurationSupplier) {
        try {
            return configurationSupplier.get().cassandraMapping((BeanFactory)context.getBeanFactory(), (CassandraCustomConversions)context.getBean(CassandraCustomConversions.class));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CassandraTemplate getCassandraTemplate(GenericApplicationContext context, Supplier<CassandraDataAutoConfiguration> configurationSupplier) {
        try {
            return configurationSupplier.get().cassandraTemplate((SessionFactory)context.getBean(SessionFactory.class), (CassandraConverter)context.getBean(CassandraConverter.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SessionFactoryFactoryBean getCassandraSessionFactoryBean(GenericApplicationContext context, Supplier<CassandraDataAutoConfiguration> configurationSupplier) {
        try {
            return configurationSupplier.get().cassandraSessionFactory((Environment)context.getEnvironment(), (CassandraConverter)context.getBean(CassandraConverter.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

